/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.pico.api.ActivationLog;
import io.helidon.pico.api.ActivationRequest;
import io.helidon.pico.api.ActivationResult;
import io.helidon.pico.api.Bootstrap;
import io.helidon.pico.api.ContextualServiceQuery;
import io.helidon.pico.api.DefaultActivationRequest;
import io.helidon.pico.api.DefaultContextualServiceQuery;
import io.helidon.pico.api.DefaultServiceInfoCriteria;
import io.helidon.pico.api.Injector;
import io.helidon.pico.api.Metrics;
import io.helidon.pico.api.Phase;
import io.helidon.pico.api.PicoServicesConfig;
import io.helidon.pico.api.PicoServicesHolder;
import io.helidon.pico.api.ServiceInfoCriteria;
import io.helidon.pico.api.Services;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public interface PicoServices {
    public static final ServiceInfoCriteria EMPTY_CRITERIA = DefaultServiceInfoCriteria.builder().build();
    public static final ContextualServiceQuery SERVICE_QUERY_REQUIRED = ((DefaultContextualServiceQuery.Builder)((DefaultContextualServiceQuery.Builder)DefaultContextualServiceQuery.builder().serviceInfoCriteria(EMPTY_CRITERIA)).expected(true)).build();

    public Bootstrap bootstrap();

    public static boolean isDebugEnabled() {
        Supplier<Boolean> lastResortSupplier = () -> Boolean.getBoolean("pico.debug");
        Optional<Bootstrap> bootstrap = PicoServices.globalBootstrap();
        if (bootstrap.isPresent()) {
            return PicoServicesConfig.asBoolean("pico.debug", lastResortSupplier);
        }
        return lastResortSupplier.get();
    }

    public static Optional<Bootstrap> globalBootstrap() {
        return PicoServicesHolder.bootstrap(false);
    }

    public static Bootstrap realizedGlobalBootStrap() {
        Optional<Bootstrap> bootstrap = PicoServices.globalBootstrap();
        return bootstrap.orElseGet(() -> PicoServicesHolder.bootstrap(true).orElseThrow());
    }

    public static void globalBootstrap(Bootstrap bootstrap) {
        Objects.requireNonNull(bootstrap);
        PicoServicesHolder.bootstrap(bootstrap);
    }

    public static Optional<PicoServices> picoServices() {
        return PicoServicesHolder.picoServices();
    }

    public static Services realizedServices() {
        return PicoServices.picoServices().orElseThrow().services();
    }

    public static Optional<Services> unrealizedServices() {
        PicoServices picoServices = PicoServices.picoServices().orElse(null);
        if (picoServices == null) {
            return Optional.empty();
        }
        return picoServices.services(false);
    }

    default public Services services() {
        return this.services(true).orElseThrow();
    }

    public Optional<? extends Services> services(boolean var1);

    public PicoServicesConfig config();

    public Optional<Injector> injector();

    public Optional<Map<String, ActivationResult>> shutdown();

    public Optional<ActivationLog> activationLog();

    public Optional<Metrics> metrics();

    public Optional<Set<ServiceInfoCriteria>> lookups();

    public static ActivationRequest createDefaultActivationRequest() {
        return ((DefaultActivationRequest.Builder)DefaultActivationRequest.builder().targetPhase(PicoServices.terminalActivationPhase())).build();
    }

    public static Phase terminalActivationPhase() {
        Optional<Bootstrap> globalBootstrap = PicoServices.globalBootstrap();
        if (globalBootstrap.isPresent()) {
            Optional<Phase> limitPhase = globalBootstrap.get().limitRuntimePhase();
            return limitPhase.orElse(Phase.ACTIVE);
        }
        return Phase.ACTIVE;
    }
}

