/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.pico.api.PicoException;
import io.helidon.pico.api.ServiceProvider;
import java.util.Objects;
import java.util.Optional;

public class PicoServiceProviderException
extends PicoException {
    private final ServiceProvider<?> serviceProvider;

    public PicoServiceProviderException(String msg) {
        super(msg);
        this.serviceProvider = null;
    }

    public PicoServiceProviderException(String msg, Throwable cause) {
        super(msg, cause);
        this.serviceProvider = cause instanceof PicoServiceProviderException ? (ServiceProvider)((PicoServiceProviderException)cause).serviceProvider().orElse(null) : null;
    }

    public PicoServiceProviderException(String msg, ServiceProvider<?> serviceProvider) {
        super(msg);
        Objects.requireNonNull(serviceProvider);
        this.serviceProvider = serviceProvider;
    }

    public PicoServiceProviderException(String msg, Throwable cause, ServiceProvider<?> serviceProvider) {
        super(msg, cause);
        Objects.requireNonNull(serviceProvider);
        this.serviceProvider = serviceProvider;
    }

    public Optional<ServiceProvider<?>> serviceProvider() {
        return Optional.ofNullable(this.serviceProvider);
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (String)(this.serviceProvider == null ? "" : ": service provider: " + String.valueOf(this.serviceProvider));
    }
}

