/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.pico.api.ContextualServiceQuery;
import io.helidon.pico.api.PicoException;
import io.helidon.pico.api.PicoServiceProviderException;
import io.helidon.pico.api.PicoServices;
import io.helidon.pico.api.ServiceProvider;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Optional;

public interface InjectionPointProvider<T>
extends Provider<T> {
    default public T get() {
        return this.first(PicoServices.SERVICE_QUERY_REQUIRED).orElseThrow(() -> this.couldNotFindMatch());
    }

    public Optional<T> first(ContextualServiceQuery var1);

    default public List<T> list(ContextualServiceQuery query) {
        return this.first(query).map(List::of).orElseGet(List::of);
    }

    private PicoException couldNotFindMatch() {
        if (this instanceof ServiceProvider) {
            return new PicoServiceProviderException("Expected to find a match", (ServiceProvider)this);
        }
        return new PicoException("Expected to find a match for " + String.valueOf(this));
    }
}

