/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.Builder;
import io.helidon.pico.api.DefaultDependencyInfo;
import io.helidon.pico.api.DependencyInfo;
import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.ServiceInfoCriteria;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@Builder
public interface DependenciesInfo {
    public Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies();

    public Optional<String> fromServiceTypeName();

    default public Set<DependencyInfo> allDependencies() {
        TreeSet<DependencyInfo> all = new TreeSet<DependencyInfo>(DependenciesInfo.comparator());
        this.serviceInfoDependencies().values().forEach(all::addAll);
        return all;
    }

    default public List<DependencyInfo> allDependenciesFor(String elemName) {
        Objects.requireNonNull(elemName);
        return this.allDependencies().stream().flatMap(dep -> dep.injectionPointDependencies().stream().filter(ipi -> elemName.equals(ipi.elementName())).map(ipi -> ((DefaultDependencyInfo.Builder)DefaultDependencyInfo.toBuilder(dep).injectionPointDependencies(Set.of(ipi))).build())).sorted(DependenciesInfo.comparator()).collect(Collectors.toList());
    }

    public static java.util.Comparator<DependencyInfo> comparator() {
        return new Comparator();
    }

    public static class Comparator
    implements java.util.Comparator<DependencyInfo>,
    Serializable {
        private Comparator() {
        }

        @Override
        public int compare(DependencyInfo o1, DependencyInfo o2) {
            InjectionPointInfo ipi1 = o1.injectionPointDependencies().iterator().next();
            InjectionPointInfo ipi2 = o2.injectionPointDependencies().iterator().next();
            java.util.Comparator<InjectionPointInfo> idComp = java.util.Comparator.comparing(InjectionPointInfo::baseIdentity);
            java.util.Comparator<InjectionPointInfo> posComp = java.util.Comparator.comparing(Comparator::elementOffsetOf);
            return idComp.thenComparing(posComp).compare(ipi1, ipi2);
        }

        private static int elementOffsetOf(InjectionPointInfo ipi) {
            return ipi.elementOffset().orElse(0);
        }
    }
}

