/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.common.types.AnnotationAndValue;
import io.helidon.common.types.DefaultAnnotationAndValue;
import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeName;
import io.helidon.pico.api.CommonQualifiers;
import io.helidon.pico.api.QualifierAndValue;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;

public class DefaultQualifierAndValue
extends DefaultAnnotationAndValue
implements QualifierAndValue,
Comparable<AnnotationAndValue> {
    protected DefaultQualifierAndValue(Builder b) {
        super((DefaultAnnotationAndValue.Builder)b);
    }

    public static DefaultQualifierAndValue createNamed(String name) {
        Objects.requireNonNull(name);
        return (DefaultQualifierAndValue)DefaultQualifierAndValue.builder().typeName(CommonQualifiers.NAMED).value(name).build();
    }

    public static DefaultQualifierAndValue create(Class<? extends Annotation> qualifierType) {
        Objects.requireNonNull(qualifierType);
        return (DefaultQualifierAndValue)DefaultQualifierAndValue.builder().typeName((TypeName)DefaultTypeName.create(qualifierType)).build();
    }

    public static DefaultQualifierAndValue create(Class<? extends Annotation> qualifierType, String val) {
        Objects.requireNonNull(qualifierType);
        return (DefaultQualifierAndValue)DefaultQualifierAndValue.builder().typeName((TypeName)DefaultTypeName.create(qualifierType)).value(val).build();
    }

    public static DefaultQualifierAndValue create(String qualifierTypeName, String val) {
        return (DefaultQualifierAndValue)DefaultQualifierAndValue.builder().typeName((TypeName)DefaultTypeName.createFromTypeName((String)qualifierTypeName)).value(val).build();
    }

    public static DefaultQualifierAndValue create(TypeName qualifierType, String val) {
        return (DefaultQualifierAndValue)DefaultQualifierAndValue.builder().typeName(qualifierType).value(val).build();
    }

    public static DefaultQualifierAndValue create(TypeName qualifierType, Map<String, String> vals) {
        return (DefaultQualifierAndValue)DefaultQualifierAndValue.builder().typeName(qualifierType).values(vals).build();
    }

    public static QualifierAndValue convert(AnnotationAndValue annotationAndValue) {
        if (annotationAndValue instanceof QualifierAndValue) {
            return (QualifierAndValue)annotationAndValue;
        }
        return (QualifierAndValue)((DefaultAnnotationAndValue.Builder)DefaultQualifierAndValue.builder().typeName(annotationAndValue.typeName()).values(annotationAndValue.values()).update(it -> annotationAndValue.value().ifPresent(arg_0 -> ((DefaultAnnotationAndValue.Builder)it).value(arg_0)))).build();
    }

    @Override
    public int compareTo(AnnotationAndValue other) {
        return this.typeName().compareTo((Object)other.typeName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DefaultAnnotationAndValue.Builder {
        protected Builder() {
        }

        public DefaultQualifierAndValue build() {
            return new DefaultQualifierAndValue(this);
        }
    }
}

