/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.Builder;
import io.helidon.pico.api.CallingContextFactory;
import io.helidon.pico.api.DefaultCallingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Builder(interceptor=BuilderInterceptor.class)
public abstract class CallingContext {
    public static final String DEBUG_HINT = "use the (-D and/or -A) tag 'pico.debug=true' to see full trace output.";
    private static CallingContext defaultCallingContext;

    protected CallingContext() {
    }

    public String toString() {
        String prettyPrintStackTrace = String.join((CharSequence)"\n", CallingContext.stackTraceOf(this.trace()));
        return "module name: " + String.valueOf(this.moduleName()) + "; thread name: " + this.threadName() + "; trace:\n" + prettyPrintStackTrace;
    }

    public abstract StackTraceElement[] trace();

    public abstract Optional<String> moduleName();

    public abstract String threadName();

    static List<String> stackTraceOf(StackTraceElement[] trace) {
        ArrayList<String> result = new ArrayList<String>();
        for (StackTraceElement e : trace) {
            result.add(e.toString());
        }
        return result;
    }

    public static void globalCallingContext(CallingContext callingContext, boolean throwIfAlreadySet) {
        Objects.requireNonNull(callingContext);
        CallingContext global = defaultCallingContext;
        if (global != null && throwIfAlreadySet) {
            CallingContext currentCallingContext = CallingContextFactory.create(true).orElseThrow();
            throw new IllegalStateException("Expected to be the owner of the calling context. This context is: " + String.valueOf(currentCallingContext) + "\n Context previously set was: " + String.valueOf(global));
        }
        defaultCallingContext = callingContext;
    }

    public static String toErrorMessage(CallingContext callingContext, String msg) {
        return msg + " - previous calling context: " + String.valueOf(callingContext);
    }

    public static String toErrorMessage(String msg) {
        return msg + " - use the (-D and/or -A) tag 'pico.debug=true' to see full trace output.";
    }

    static class BuilderInterceptor
    implements io.helidon.builder.BuilderInterceptor<DefaultCallingContext.Builder> {
        BuilderInterceptor() {
        }

        public DefaultCallingContext.Builder intercept(DefaultCallingContext.Builder target) {
            if (target.threadName() == null) {
                target.threadName(Thread.currentThread().getName());
            }
            return target;
        }
    }
}

