/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.Builder;
import io.helidon.pico.api.ActivationStatus;
import io.helidon.pico.api.DefaultActivationResult;
import io.helidon.pico.api.Phase;
import io.helidon.pico.api.ServiceProvider;
import io.helidon.pico.spi.InjectionPlan;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;

@Builder
public interface ActivationResult {
    public ServiceProvider<?> serviceProvider();

    public Optional<Future<ActivationResult>> finishedActivationResult();

    public Phase startingActivationPhase();

    public Phase targetActivationPhase();

    public Phase finishingActivationPhase();

    public Optional<ActivationStatus> finishingStatus();

    public Map<String, ? extends InjectionPlan> injectionPlans();

    public Map<String, Object> resolvedDependencies();

    public boolean wasResolved();

    public Optional<Throwable> error();

    default public boolean finished() {
        Future f = this.finishedActivationResult().orElse(null);
        return f == null || f.isDone();
    }

    default public boolean success() {
        return this.finishingStatus().orElse(null) != ActivationStatus.FAILURE;
    }

    default public boolean failure() {
        return !this.success();
    }

    public static ActivationResult createSuccess(ServiceProvider<?> serviceProvider) {
        Phase phase = serviceProvider.currentActivationPhase();
        return ((DefaultActivationResult.Builder)((DefaultActivationResult.Builder)((DefaultActivationResult.Builder)((DefaultActivationResult.Builder)((DefaultActivationResult.Builder)DefaultActivationResult.builder().serviceProvider(serviceProvider)).startingActivationPhase(phase)).finishingActivationPhase(phase)).targetActivationPhase(phase)).finishingStatus(ActivationStatus.SUCCESS)).build();
    }
}

