/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.Builder;
import io.helidon.builder.BuilderInterceptor;
import io.helidon.pico.api.ActivationResult;
import io.helidon.pico.api.DefaultActivationLogEntry;
import io.helidon.pico.api.Event;
import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.ServiceProvider;
import java.time.Instant;
import java.util.Optional;

@Builder(interceptor=Interceptor.class)
public interface ActivationLogEntry {
    public Event event();

    public Optional<String> message();

    public Optional<ActivationResult> activationResult();

    public Optional<ServiceProvider<?>> serviceProvider();

    public Optional<InjectionPointInfo> injectionPoint();

    public Instant time();

    public Optional<Throwable> error();

    public long threadId();

    public static class Interceptor
    implements BuilderInterceptor<DefaultActivationLogEntry.Builder> {
        Interceptor() {
        }

        public DefaultActivationLogEntry.Builder intercept(DefaultActivationLogEntry.Builder b) {
            if (b.time() == null) {
                b.time(Instant.now());
            }
            if (b.threadId() == 0L) {
                b.threadId(Thread.currentThread().getId());
            }
            if (b.event() == null) {
                b.event(Event.FINISHED);
            }
            return b;
        }
    }
}

