/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.QualifierAndValue;
import io.helidon.pico.api.ServiceInfoCriteria;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractServiceInfoCriteria
implements ServiceInfoCriteria {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractServiceInfoCriteria.__calcMeta());
    private final Optional<String> serviceTypeName;
    private final Set<String> scopeTypeNames;
    private final Set<QualifierAndValue> qualifiers;
    private final Set<String> contractsImplemented;
    private final Optional<Integer> runLevel;
    private final Optional<Double> weight;
    private final Set<String> externalContractsImplemented;
    private final Optional<String> activatorTypeName;
    private final Optional<String> moduleName;
    private final boolean includeIntercepted;

    protected AbstractServiceInfoCriteria(Builder<?, ?> b) {
        this.serviceTypeName = b.serviceTypeName;
        this.scopeTypeNames = Collections.unmodifiableSet(new LinkedHashSet(b.scopeTypeNames));
        this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet(b.qualifiers));
        this.contractsImplemented = Collections.unmodifiableSet(new LinkedHashSet(b.contractsImplemented));
        this.runLevel = b.runLevel;
        this.weight = b.weight;
        this.externalContractsImplemented = Collections.unmodifiableSet(new LinkedHashSet(b.externalContractsImplemented));
        this.activatorTypeName = b.activatorTypeName;
        this.moduleName = b.moduleName;
        this.includeIntercepted = b.includeIntercepted;
    }

    @Override
    public Optional<String> serviceTypeName() {
        return this.serviceTypeName;
    }

    @Override
    public Set<String> scopeTypeNames() {
        return this.scopeTypeNames;
    }

    @Override
    public Set<QualifierAndValue> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public Set<String> contractsImplemented() {
        return this.contractsImplemented;
    }

    @Override
    public Optional<Integer> runLevel() {
        return this.runLevel;
    }

    @Override
    public Optional<Double> weight() {
        return this.weight;
    }

    @Override
    public Set<String> externalContractsImplemented() {
        return this.externalContractsImplemented;
    }

    @Override
    public Optional<String> activatorTypeName() {
        return this.activatorTypeName;
    }

    @Override
    public Optional<String> moduleName() {
        return this.moduleName;
    }

    @Override
    public boolean includeIntercepted() {
        return this.includeIntercepted;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("serviceTypeName", Map.of("__type", Optional.class, "__componentType", String.class));
        metaProps.put("scopeTypeNames", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("qualifiers", Map.of("__type", Set.class, "__componentType", QualifierAndValue.class));
        metaProps.put("contractsImplemented", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("runLevel", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("weight", Map.of("__type", Optional.class, "__componentType", Double.class));
        metaProps.put("externalContractsImplemented", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("activatorTypeName", Map.of("__type", Optional.class, "__componentType", String.class));
        metaProps.put("moduleName", Map.of("__type", Optional.class, "__componentType", String.class));
        metaProps.put("includeIntercepted", Map.of("__type", Boolean.TYPE));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return ServiceInfoCriteria.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "serviceTypeName=" + String.valueOf(this.serviceTypeName()) + ", ";
        result = (String)result + "scopeTypeNames=" + String.valueOf(this.scopeTypeNames()) + ", ";
        result = (String)result + "qualifiers=" + String.valueOf(this.qualifiers()) + ", ";
        result = (String)result + "contractsImplemented=" + String.valueOf(this.contractsImplemented()) + ", ";
        result = (String)result + "runLevel=" + String.valueOf(this.runLevel()) + ", ";
        result = (String)result + "weight=" + String.valueOf(this.weight()) + ", ";
        result = (String)result + "externalContractsImplemented=" + String.valueOf(this.externalContractsImplemented()) + ", ";
        result = (String)result + "activatorTypeName=" + String.valueOf(this.activatorTypeName()) + ", ";
        result = (String)result + "moduleName=" + String.valueOf(this.moduleName()) + ", ";
        result = (String)result + "includeIntercepted=" + this.includeIntercepted();
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.serviceTypeName(), this.scopeTypeNames(), this.qualifiers(), this.contractsImplemented(), this.runLevel(), this.weight(), this.externalContractsImplemented(), this.activatorTypeName(), this.moduleName(), this.includeIntercepted());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ServiceInfoCriteria)) {
            return false;
        }
        ServiceInfoCriteria other = (ServiceInfoCriteria)another;
        boolean equals = true;
        equals &= Objects.equals(this.serviceTypeName(), other.serviceTypeName());
        equals &= Objects.equals(this.scopeTypeNames(), other.scopeTypeNames());
        equals &= Objects.equals(this.qualifiers(), other.qualifiers());
        equals &= Objects.equals(this.contractsImplemented(), other.contractsImplemented());
        equals &= Objects.equals(this.runLevel(), other.runLevel());
        equals &= Objects.equals(this.weight(), other.weight());
        equals &= Objects.equals(this.externalContractsImplemented(), other.externalContractsImplemented());
        equals &= Objects.equals(this.activatorTypeName(), other.activatorTypeName());
        equals &= Objects.equals(this.moduleName(), other.moduleName());
        return equals &= Objects.equals(this.includeIntercepted(), other.includeIntercepted());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("serviceTypeName", () -> this.serviceTypeName(), __META_PROPS.get("serviceTypeName"), userDefinedCtx, Optional.class, new Class[]{String.class});
        visitor.visit("scopeTypeNames", () -> this.scopeTypeNames(), __META_PROPS.get("scopeTypeNames"), userDefinedCtx, Set.class, new Class[]{String.class});
        visitor.visit("qualifiers", () -> this.qualifiers(), __META_PROPS.get("qualifiers"), userDefinedCtx, Set.class, new Class[]{QualifierAndValue.class});
        visitor.visit("contractsImplemented", () -> this.contractsImplemented(), __META_PROPS.get("contractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
        visitor.visit("runLevel", () -> this.runLevel(), __META_PROPS.get("runLevel"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        visitor.visit("weight", () -> this.weight(), __META_PROPS.get("weight"), userDefinedCtx, Optional.class, new Class[]{Double.class});
        visitor.visit("externalContractsImplemented", () -> this.externalContractsImplemented(), __META_PROPS.get("externalContractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
        visitor.visit("activatorTypeName", () -> this.activatorTypeName(), __META_PROPS.get("activatorTypeName"), userDefinedCtx, Optional.class, new Class[]{String.class});
        visitor.visit("moduleName", () -> this.moduleName(), __META_PROPS.get("moduleName"), userDefinedCtx, Optional.class, new Class[]{String.class});
        visitor.visit("includeIntercepted", () -> this.includeIntercepted(), __META_PROPS.get("includeIntercepted"), userDefinedCtx, Boolean.TYPE, new Class[0]);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ServiceInfoCriteria>
    implements ServiceInfoCriteria,
    io.helidon.common.Builder<B, T> {
        protected final Set scopeTypeNames = new LinkedHashSet();
        protected final Set qualifiers = new LinkedHashSet();
        protected final Set contractsImplemented = new LinkedHashSet();
        protected final Set externalContractsImplemented = new LinkedHashSet();
        private Optional serviceTypeName = Optional.empty();
        private Optional runLevel = Optional.empty();
        private Optional weight = Optional.empty();
        private Optional activatorTypeName = Optional.empty();
        private Optional moduleName = Optional.empty();
        private boolean includeIntercepted;

        protected Builder() {
        }

        @Override
        public Optional<String> serviceTypeName() {
            return this.serviceTypeName;
        }

        @Override
        public Set<String> scopeTypeNames() {
            return this.scopeTypeNames;
        }

        @Override
        public Set<QualifierAndValue> qualifiers() {
            return this.qualifiers;
        }

        @Override
        public Set<String> contractsImplemented() {
            return this.contractsImplemented;
        }

        @Override
        public Optional<Integer> runLevel() {
            return this.runLevel;
        }

        @Override
        public Optional<Double> weight() {
            return this.weight;
        }

        @Override
        public Set<String> externalContractsImplemented() {
            return this.externalContractsImplemented;
        }

        @Override
        public Optional<String> activatorTypeName() {
            return this.activatorTypeName;
        }

        @Override
        public Optional<String> moduleName() {
            return this.moduleName;
        }

        @Override
        public boolean includeIntercepted() {
            return this.includeIntercepted;
        }

        public B serviceTypeName(Optional<String> val) {
            this.serviceTypeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B serviceTypeName(String val) {
            Objects.requireNonNull(val);
            return this.serviceTypeName(Optional.of(val));
        }

        public B scopeTypeNames(Collection<String> val) {
            this.scopeTypeNames.clear();
            this.scopeTypeNames.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addScopeTypeNames(Collection<String> val) {
            this.scopeTypeNames.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addScopeTypeName(String val) {
            Objects.requireNonNull(val);
            this.scopeTypeNames.add(val);
            return (B)((Builder)this.identity());
        }

        public B qualifiers(Collection<QualifierAndValue> val) {
            this.qualifiers.clear();
            this.qualifiers.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addQualifiers(Collection<QualifierAndValue> val) {
            this.qualifiers.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addQualifier(QualifierAndValue val) {
            Objects.requireNonNull(val);
            this.qualifiers.add(val);
            return (B)((Builder)this.identity());
        }

        public B contractsImplemented(Collection<String> val) {
            this.contractsImplemented.clear();
            this.contractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addContractsImplemented(Collection<String> val) {
            this.contractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addContractImplemented(String val) {
            Objects.requireNonNull(val);
            this.contractsImplemented.add(val);
            return (B)((Builder)this.identity());
        }

        public B runLevel(Optional<Integer> val) {
            this.runLevel = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B runLevel(Integer val) {
            Objects.requireNonNull(val);
            return this.runLevel(Optional.of(val));
        }

        public B weight(Optional<Double> val) {
            this.weight = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B weight(Double val) {
            Objects.requireNonNull(val);
            return this.weight(Optional.of(val));
        }

        public B externalContractsImplemented(Collection<String> val) {
            this.externalContractsImplemented.clear();
            this.externalContractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addExternalContractsImplemented(Collection<String> val) {
            this.externalContractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addExternalContractImplemented(String val) {
            Objects.requireNonNull(val);
            this.externalContractsImplemented.add(val);
            return (B)((Builder)this.identity());
        }

        public B activatorTypeName(Optional<String> val) {
            this.activatorTypeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B activatorTypeName(String val) {
            Objects.requireNonNull(val);
            return this.activatorTypeName(Optional.of(val));
        }

        public B moduleName(Optional<String> val) {
            this.moduleName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B moduleName(String val) {
            Objects.requireNonNull(val);
            return this.moduleName(Optional.of(val));
        }

        public B includeIntercepted(boolean val) {
            this.includeIntercepted = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.serviceTypeName(val.serviceTypeName());
            this.scopeTypeNames(val.scopeTypeNames());
            this.qualifiers(val.qualifiers());
            this.contractsImplemented(val.contractsImplemented());
            this.runLevel(val.runLevel());
            this.weight(val.weight());
            this.externalContractsImplemented(val.externalContractsImplemented());
            this.activatorTypeName(val.activatorTypeName());
            this.moduleName(val.moduleName());
            this.includeIntercepted(val.includeIntercepted());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("serviceTypeName", () -> this.serviceTypeName, __META_PROPS.get("serviceTypeName"), userDefinedCtx, Optional.class, new Class[]{String.class});
            visitor.visit("scopeTypeNames", () -> this.scopeTypeNames, __META_PROPS.get("scopeTypeNames"), userDefinedCtx, Set.class, new Class[]{String.class});
            visitor.visit("qualifiers", () -> this.qualifiers, __META_PROPS.get("qualifiers"), userDefinedCtx, Set.class, new Class[]{QualifierAndValue.class});
            visitor.visit("contractsImplemented", () -> this.contractsImplemented, __META_PROPS.get("contractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
            visitor.visit("runLevel", () -> this.runLevel, __META_PROPS.get("runLevel"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
            visitor.visit("weight", () -> this.weight, __META_PROPS.get("weight"), userDefinedCtx, Optional.class, new Class[]{Double.class});
            visitor.visit("externalContractsImplemented", () -> this.externalContractsImplemented, __META_PROPS.get("externalContractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
            visitor.visit("activatorTypeName", () -> this.activatorTypeName, __META_PROPS.get("activatorTypeName"), userDefinedCtx, Optional.class, new Class[]{String.class});
            visitor.visit("moduleName", () -> this.moduleName, __META_PROPS.get("moduleName"), userDefinedCtx, Optional.class, new Class[]{String.class});
            visitor.visit("includeIntercepted", () -> this.includeIntercepted, __META_PROPS.get("includeIntercepted"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        }
    }
}

