/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.QualifierAndValue;
import io.helidon.pico.api.ServiceInfoBasics;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractServiceInfoBasics
implements ServiceInfoBasics {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractServiceInfoBasics.__calcMeta());
    private final String serviceTypeName;
    private final Set<String> scopeTypeNames;
    private final Set<QualifierAndValue> qualifiers;
    private final Set<String> contractsImplemented;
    private final Optional<Integer> declaredRunLevel;
    private final Optional<Double> declaredWeight;

    protected AbstractServiceInfoBasics(Builder<?, ?> b) {
        this.serviceTypeName = b.serviceTypeName;
        this.scopeTypeNames = Collections.unmodifiableSet(new LinkedHashSet(b.scopeTypeNames));
        this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet(b.qualifiers));
        this.contractsImplemented = Collections.unmodifiableSet(new LinkedHashSet(b.contractsImplemented));
        this.declaredRunLevel = b.declaredRunLevel;
        this.declaredWeight = b.declaredWeight;
    }

    @Override
    public String serviceTypeName() {
        return this.serviceTypeName;
    }

    @Override
    public Set<String> scopeTypeNames() {
        return this.scopeTypeNames;
    }

    @Override
    public Set<QualifierAndValue> qualifiers() {
        return this.qualifiers;
    }

    @Override
    public Set<String> contractsImplemented() {
        return this.contractsImplemented;
    }

    @Override
    public Optional<Integer> declaredRunLevel() {
        return this.declaredRunLevel;
    }

    @Override
    public Optional<Double> declaredWeight() {
        return this.declaredWeight;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("serviceTypeName", Map.of("__type", String.class));
        metaProps.put("scopeTypeNames", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("qualifiers", Map.of("__type", Set.class, "__componentType", QualifierAndValue.class));
        metaProps.put("contractsImplemented", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("declaredRunLevel", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("declaredWeight", Map.of("__type", Optional.class, "__componentType", Double.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return ServiceInfoBasics.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "serviceTypeName=" + this.serviceTypeName() + ", ";
        result = (String)result + "scopeTypeNames=" + String.valueOf(this.scopeTypeNames()) + ", ";
        result = (String)result + "qualifiers=" + String.valueOf(this.qualifiers()) + ", ";
        result = (String)result + "contractsImplemented=" + String.valueOf(this.contractsImplemented()) + ", ";
        result = (String)result + "declaredRunLevel=" + String.valueOf(this.declaredRunLevel()) + ", ";
        result = (String)result + "declaredWeight=" + String.valueOf(this.declaredWeight());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.serviceTypeName(), this.scopeTypeNames(), this.qualifiers(), this.contractsImplemented(), this.declaredRunLevel(), this.declaredWeight());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ServiceInfoBasics)) {
            return false;
        }
        ServiceInfoBasics other = (ServiceInfoBasics)another;
        boolean equals = true;
        equals &= Objects.equals(this.serviceTypeName(), other.serviceTypeName());
        equals &= Objects.equals(this.scopeTypeNames(), other.scopeTypeNames());
        equals &= Objects.equals(this.qualifiers(), other.qualifiers());
        equals &= Objects.equals(this.contractsImplemented(), other.contractsImplemented());
        equals &= Objects.equals(this.declaredRunLevel(), other.declaredRunLevel());
        return equals &= Objects.equals(this.declaredWeight(), other.declaredWeight());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("serviceTypeName", () -> this.serviceTypeName(), __META_PROPS.get("serviceTypeName"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("scopeTypeNames", () -> this.scopeTypeNames(), __META_PROPS.get("scopeTypeNames"), userDefinedCtx, Set.class, new Class[]{String.class});
        visitor.visit("qualifiers", () -> this.qualifiers(), __META_PROPS.get("qualifiers"), userDefinedCtx, Set.class, new Class[]{QualifierAndValue.class});
        visitor.visit("contractsImplemented", () -> this.contractsImplemented(), __META_PROPS.get("contractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
        visitor.visit("declaredRunLevel", () -> this.declaredRunLevel(), __META_PROPS.get("declaredRunLevel"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        visitor.visit("declaredWeight", () -> this.declaredWeight(), __META_PROPS.get("declaredWeight"), userDefinedCtx, Optional.class, new Class[]{Double.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ServiceInfoBasics>
    implements ServiceInfoBasics,
    io.helidon.common.Builder<B, T> {
        protected final Set scopeTypeNames = new LinkedHashSet();
        protected final Set qualifiers = new LinkedHashSet();
        protected final Set contractsImplemented = new LinkedHashSet();
        private String serviceTypeName;
        private Optional declaredRunLevel = Optional.empty();
        private Optional declaredWeight = Optional.empty();

        protected Builder() {
        }

        @Override
        public String serviceTypeName() {
            return this.serviceTypeName;
        }

        @Override
        public Set<String> scopeTypeNames() {
            return this.scopeTypeNames;
        }

        @Override
        public Set<QualifierAndValue> qualifiers() {
            return this.qualifiers;
        }

        @Override
        public Set<String> contractsImplemented() {
            return this.contractsImplemented;
        }

        @Override
        public Optional<Integer> declaredRunLevel() {
            return this.declaredRunLevel;
        }

        @Override
        public Optional<Double> declaredWeight() {
            return this.declaredWeight;
        }

        public B serviceTypeName(String val) {
            this.serviceTypeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B scopeTypeNames(Collection<String> val) {
            this.scopeTypeNames.clear();
            this.scopeTypeNames.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addScopeTypeNames(Collection<String> val) {
            this.scopeTypeNames.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addScopeTypeName(String val) {
            Objects.requireNonNull(val);
            this.scopeTypeNames.add(val);
            return (B)((Builder)this.identity());
        }

        public B qualifiers(Collection<QualifierAndValue> val) {
            this.qualifiers.clear();
            this.qualifiers.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addQualifiers(Collection<QualifierAndValue> val) {
            this.qualifiers.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addQualifier(QualifierAndValue val) {
            Objects.requireNonNull(val);
            this.qualifiers.add(val);
            return (B)((Builder)this.identity());
        }

        public B contractsImplemented(Collection<String> val) {
            this.contractsImplemented.clear();
            this.contractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addContractsImplemented(Collection<String> val) {
            this.contractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addContractsImplemented(String val) {
            Objects.requireNonNull(val);
            this.contractsImplemented.add(val);
            return (B)((Builder)this.identity());
        }

        public B declaredRunLevel(Optional<Integer> val) {
            this.declaredRunLevel = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B declaredRunLevel(Integer val) {
            Objects.requireNonNull(val);
            return this.declaredRunLevel(Optional.of(val));
        }

        public B declaredWeight(Optional<Double> val) {
            this.declaredWeight = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B declaredWeight(Double val) {
            Objects.requireNonNull(val);
            return this.declaredWeight(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.serviceTypeName(val.serviceTypeName());
            this.scopeTypeNames(val.scopeTypeNames());
            this.qualifiers(val.qualifiers());
            this.contractsImplemented(val.contractsImplemented());
            this.declaredRunLevel(val.declaredRunLevel());
            this.declaredWeight(val.declaredWeight());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("serviceTypeName", () -> this.serviceTypeName, __META_PROPS.get("serviceTypeName"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("scopeTypeNames", () -> this.scopeTypeNames, __META_PROPS.get("scopeTypeNames"), userDefinedCtx, Set.class, new Class[]{String.class});
            visitor.visit("qualifiers", () -> this.qualifiers, __META_PROPS.get("qualifiers"), userDefinedCtx, Set.class, new Class[]{QualifierAndValue.class});
            visitor.visit("contractsImplemented", () -> this.contractsImplemented, __META_PROPS.get("contractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
            visitor.visit("declaredRunLevel", () -> this.declaredRunLevel, __META_PROPS.get("declaredRunLevel"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
            visitor.visit("declaredWeight", () -> this.declaredWeight, __META_PROPS.get("declaredWeight"), userDefinedCtx, Optional.class, new Class[]{Double.class});
        }
    }
}

