/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.AbstractServiceInfoBasics;
import io.helidon.pico.api.QualifierAndValue;
import io.helidon.pico.api.ServiceInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractServiceInfo
extends AbstractServiceInfoBasics
implements ServiceInfo {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractServiceInfo.__calcMeta());
    private final Set<String> externalContractsImplemented;
    private final Optional<String> activatorTypeName;
    private final Optional<String> moduleName;

    protected AbstractServiceInfo(Builder<?, ?> b) {
        super(b);
        this.externalContractsImplemented = Collections.unmodifiableSet(new LinkedHashSet(b.externalContractsImplemented));
        this.activatorTypeName = b.activatorTypeName;
        this.moduleName = b.moduleName;
    }

    @Override
    public Set<String> externalContractsImplemented() {
        return this.externalContractsImplemented;
    }

    @Override
    public Optional<String> activatorTypeName() {
        return this.activatorTypeName;
    }

    @Override
    public Optional<String> moduleName() {
        return this.moduleName;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("serviceTypeName", Map.of("__type", String.class));
        metaProps.put("scopeTypeNames", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("qualifiers", Map.of("__type", Set.class, "__componentType", QualifierAndValue.class));
        metaProps.put("contractsImplemented", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("declaredRunLevel", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("declaredWeight", Map.of("__type", Optional.class, "__componentType", Double.class));
        metaProps.put("externalContractsImplemented", Map.of("__type", Set.class, "__componentType", String.class));
        metaProps.put("activatorTypeName", Map.of("__type", Optional.class, "__componentType", String.class));
        metaProps.put("moduleName", Map.of("__type", Optional.class, "__componentType", String.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    @Override
    public String toString() {
        return ServiceInfo.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    @Override
    protected String toStringInner() {
        Object result = super.toStringInner();
        if (!((String)result).isEmpty() && !((String)result).endsWith(", ")) {
            result = (String)result + ", ";
        }
        result = (String)result + "externalContractsImplemented=" + String.valueOf(this.externalContractsImplemented()) + ", ";
        result = (String)result + "activatorTypeName=" + String.valueOf(this.activatorTypeName()) + ", ";
        result = (String)result + "moduleName=" + String.valueOf(this.moduleName());
        return result;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + Objects.hash(this.externalContractsImplemented(), this.activatorTypeName(), this.moduleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo other = (ServiceInfo)another;
        boolean equals = super.equals(other);
        equals &= Objects.equals(this.externalContractsImplemented(), other.externalContractsImplemented());
        equals &= Objects.equals(this.activatorTypeName(), other.activatorTypeName());
        return equals &= Objects.equals(this.moduleName(), other.moduleName());
    }

    @Override
    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        super.visitAttributes(visitor, userDefinedCtx);
        visitor.visit("externalContractsImplemented", () -> this.externalContractsImplemented(), __META_PROPS.get("externalContractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
        visitor.visit("activatorTypeName", () -> this.activatorTypeName(), __META_PROPS.get("activatorTypeName"), userDefinedCtx, Optional.class, new Class[]{String.class});
        visitor.visit("moduleName", () -> this.moduleName(), __META_PROPS.get("moduleName"), userDefinedCtx, Optional.class, new Class[]{String.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ServiceInfo>
    extends AbstractServiceInfoBasics.Builder<B, T>
    implements ServiceInfo {
        protected final Set externalContractsImplemented = new LinkedHashSet();
        private Optional activatorTypeName = Optional.empty();
        private Optional moduleName = Optional.empty();

        protected Builder() {
        }

        @Override
        public Set<String> externalContractsImplemented() {
            return this.externalContractsImplemented;
        }

        @Override
        public Optional<String> activatorTypeName() {
            return this.activatorTypeName;
        }

        @Override
        public Optional<String> moduleName() {
            return this.moduleName;
        }

        public B externalContractsImplemented(Collection<String> val) {
            this.externalContractsImplemented.clear();
            this.externalContractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addExternalContractsImplemented(Collection<String> val) {
            this.externalContractsImplemented.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addExternalContractsImplemented(String val) {
            Objects.requireNonNull(val);
            this.externalContractsImplemented.add(val);
            return (B)((Builder)this.identity());
        }

        public B activatorTypeName(Optional<String> val) {
            this.activatorTypeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B activatorTypeName(String val) {
            Objects.requireNonNull(val);
            return this.activatorTypeName(Optional.of(val));
        }

        public B moduleName(Optional<String> val) {
            this.moduleName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B moduleName(String val) {
            Objects.requireNonNull(val);
            return this.moduleName(Optional.of(val));
        }

        @Override
        public B accept(T val) {
            Objects.requireNonNull(val);
            super.accept(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.externalContractsImplemented(val.externalContractsImplemented());
            this.activatorTypeName(val.activatorTypeName());
            this.moduleName(val.moduleName());
        }

        @Override
        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            super.visitAttributes(visitor, userDefinedCtx);
            visitor.visit("externalContractsImplemented", () -> this.externalContractsImplemented, __META_PROPS.get("externalContractsImplemented"), userDefinedCtx, Set.class, new Class[]{String.class});
            visitor.visit("activatorTypeName", () -> this.activatorTypeName, __META_PROPS.get("activatorTypeName"), userDefinedCtx, Optional.class, new Class[]{String.class});
            visitor.visit("moduleName", () -> this.moduleName, __META_PROPS.get("moduleName"), userDefinedCtx, Optional.class, new Class[]{String.class});
        }
    }
}

