/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.PicoServicesConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractPicoServicesConfig
extends PicoServicesConfig {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractPicoServicesConfig.__calcMeta());
    private final String providerName;
    private final String providerVersion;
    private final boolean supportsDynamic;
    private final boolean supportsReflection;
    private final boolean supportsCompileTime;
    private final boolean supportsJsr330;
    private final boolean supportsJsr330Statics;
    private final boolean supportsJsr330Privates;
    private final boolean supportsContextualLookup;

    protected AbstractPicoServicesConfig(Builder<?, ?> b) {
        this.providerName = b.providerName;
        this.providerVersion = b.providerVersion;
        this.supportsDynamic = b.supportsDynamic;
        this.supportsReflection = b.supportsReflection;
        this.supportsCompileTime = b.supportsCompileTime;
        this.supportsJsr330 = b.supportsJsr330;
        this.supportsJsr330Statics = b.supportsJsr330Statics;
        this.supportsJsr330Privates = b.supportsJsr330Privates;
        this.supportsContextualLookup = b.supportsContextualLookup;
    }

    @Override
    public String providerName() {
        return this.providerName;
    }

    @Override
    public String providerVersion() {
        return this.providerVersion;
    }

    @Override
    public boolean supportsDynamic() {
        return this.supportsDynamic;
    }

    @Override
    public boolean supportsReflection() {
        return this.supportsReflection;
    }

    @Override
    public boolean supportsCompileTime() {
        return this.supportsCompileTime;
    }

    @Override
    public boolean supportsJsr330() {
        return this.supportsJsr330;
    }

    @Override
    public boolean supportsJsr330Statics() {
        return this.supportsJsr330Statics;
    }

    @Override
    public boolean supportsJsr330Privates() {
        return this.supportsJsr330Privates;
    }

    @Override
    public boolean supportsContextualLookup() {
        return this.supportsContextualLookup;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("providerName", AbstractPicoServicesConfig.__mapOf("__type", String.class, "key", "provider-name", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("providerVersion", AbstractPicoServicesConfig.__mapOf("__type", String.class, "key", "provider-version", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("supportsDynamic", AbstractPicoServicesConfig.__mapOf("__type", Boolean.TYPE, "key", "supports-dynamic", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "true", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("supportsReflection", AbstractPicoServicesConfig.__mapOf("__type", Boolean.TYPE, "key", "supports-reflection", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "false", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("supportsCompileTime", AbstractPicoServicesConfig.__mapOf("__type", Boolean.TYPE, "key", "supports-compile-time", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "true", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("supportsJsr330", AbstractPicoServicesConfig.__mapOf("__type", Boolean.TYPE, "key", "supports-jsr330", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "true", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("supportsJsr330Statics", AbstractPicoServicesConfig.__mapOf("__type", Boolean.TYPE, "key", "supports-jsr330-statics", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "false", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("supportsJsr330Privates", AbstractPicoServicesConfig.__mapOf("__type", Boolean.TYPE, "key", "supports-jsr330-privates", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "false", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("supportsContextualLookup", AbstractPicoServicesConfig.__mapOf("__type", Boolean.TYPE, "key", "supports-contextual-lookup", "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "false", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        return metaProps;
    }

    private static Map<String, Object> __mapOf(Object ... args) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            result.put((String)args[i], args[i + 1]);
        }
        return result;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return PicoServicesConfig.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "providerName=" + this.providerName() + ", ";
        result = (String)result + "providerVersion=" + this.providerVersion() + ", ";
        result = (String)result + "supportsDynamic=" + this.supportsDynamic() + ", ";
        result = (String)result + "supportsReflection=" + this.supportsReflection() + ", ";
        result = (String)result + "supportsCompileTime=" + this.supportsCompileTime() + ", ";
        result = (String)result + "supportsJsr330=" + this.supportsJsr330() + ", ";
        result = (String)result + "supportsJsr330Statics=" + this.supportsJsr330Statics() + ", ";
        result = (String)result + "supportsJsr330Privates=" + this.supportsJsr330Privates() + ", ";
        result = (String)result + "supportsContextualLookup=" + this.supportsContextualLookup();
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.providerName(), this.providerVersion(), this.supportsDynamic(), this.supportsReflection(), this.supportsCompileTime(), this.supportsJsr330(), this.supportsJsr330Statics(), this.supportsJsr330Privates(), this.supportsContextualLookup());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof PicoServicesConfig)) {
            return false;
        }
        PicoServicesConfig other = (PicoServicesConfig)another;
        boolean equals = true;
        equals &= Objects.equals(this.providerName(), other.providerName());
        equals &= Objects.equals(this.providerVersion(), other.providerVersion());
        equals &= Objects.equals(this.supportsDynamic(), other.supportsDynamic());
        equals &= Objects.equals(this.supportsReflection(), other.supportsReflection());
        equals &= Objects.equals(this.supportsCompileTime(), other.supportsCompileTime());
        equals &= Objects.equals(this.supportsJsr330(), other.supportsJsr330());
        equals &= Objects.equals(this.supportsJsr330Statics(), other.supportsJsr330Statics());
        equals &= Objects.equals(this.supportsJsr330Privates(), other.supportsJsr330Privates());
        return equals &= Objects.equals(this.supportsContextualLookup(), other.supportsContextualLookup());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("providerName", () -> this.providerName(), __META_PROPS.get("providerName"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("providerVersion", () -> this.providerVersion(), __META_PROPS.get("providerVersion"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("supportsDynamic", () -> this.supportsDynamic(), __META_PROPS.get("supportsDynamic"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("supportsReflection", () -> this.supportsReflection(), __META_PROPS.get("supportsReflection"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("supportsCompileTime", () -> this.supportsCompileTime(), __META_PROPS.get("supportsCompileTime"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("supportsJsr330", () -> this.supportsJsr330(), __META_PROPS.get("supportsJsr330"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("supportsJsr330Statics", () -> this.supportsJsr330Statics(), __META_PROPS.get("supportsJsr330Statics"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("supportsJsr330Privates", () -> this.supportsJsr330Privates(), __META_PROPS.get("supportsJsr330Privates"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("supportsContextualLookup", () -> this.supportsContextualLookup(), __META_PROPS.get("supportsContextualLookup"), userDefinedCtx, Boolean.TYPE, new Class[0]);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends PicoServicesConfig>
    extends PicoServicesConfig
    implements io.helidon.common.Builder<B, T> {
        private String providerName;
        private String providerVersion;
        private boolean supportsDynamic = true;
        private boolean supportsReflection = false;
        private boolean supportsCompileTime = true;
        private boolean supportsJsr330 = true;
        private boolean supportsJsr330Statics = false;
        private boolean supportsJsr330Privates = false;
        private boolean supportsContextualLookup = false;

        protected Builder() {
        }

        @Override
        public String providerName() {
            return this.providerName;
        }

        @Override
        public String providerVersion() {
            return this.providerVersion;
        }

        @Override
        public boolean supportsDynamic() {
            return this.supportsDynamic;
        }

        @Override
        public boolean supportsReflection() {
            return this.supportsReflection;
        }

        @Override
        public boolean supportsCompileTime() {
            return this.supportsCompileTime;
        }

        @Override
        public boolean supportsJsr330() {
            return this.supportsJsr330;
        }

        @Override
        public boolean supportsJsr330Statics() {
            return this.supportsJsr330Statics;
        }

        @Override
        public boolean supportsJsr330Privates() {
            return this.supportsJsr330Privates;
        }

        @Override
        public boolean supportsContextualLookup() {
            return this.supportsContextualLookup;
        }

        public B providerName(String val) {
            this.providerName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B providerVersion(String val) {
            this.providerVersion = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B supportsDynamic(boolean val) {
            this.supportsDynamic = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B supportsReflection(boolean val) {
            this.supportsReflection = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B supportsCompileTime(boolean val) {
            this.supportsCompileTime = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B supportsJsr330(boolean val) {
            this.supportsJsr330 = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B supportsJsr330Statics(boolean val) {
            this.supportsJsr330Statics = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B supportsJsr330Privates(boolean val) {
            this.supportsJsr330Privates = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B supportsContextualLookup(boolean val) {
            this.supportsContextualLookup = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.providerName(((PicoServicesConfig)val).providerName());
            this.providerVersion(((PicoServicesConfig)val).providerVersion());
            this.supportsDynamic(((PicoServicesConfig)val).supportsDynamic());
            this.supportsReflection(((PicoServicesConfig)val).supportsReflection());
            this.supportsCompileTime(((PicoServicesConfig)val).supportsCompileTime());
            this.supportsJsr330(((PicoServicesConfig)val).supportsJsr330());
            this.supportsJsr330Statics(((PicoServicesConfig)val).supportsJsr330Statics());
            this.supportsJsr330Privates(((PicoServicesConfig)val).supportsJsr330Privates());
            this.supportsContextualLookup(((PicoServicesConfig)val).supportsContextualLookup());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("providerName", () -> this.providerName, __META_PROPS.get("providerName"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("providerVersion", () -> this.providerVersion, __META_PROPS.get("providerVersion"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("supportsDynamic", () -> this.supportsDynamic, __META_PROPS.get("supportsDynamic"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("supportsReflection", () -> this.supportsReflection, __META_PROPS.get("supportsReflection"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("supportsCompileTime", () -> this.supportsCompileTime, __META_PROPS.get("supportsCompileTime"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("supportsJsr330", () -> this.supportsJsr330, __META_PROPS.get("supportsJsr330"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("supportsJsr330Statics", () -> this.supportsJsr330Statics, __META_PROPS.get("supportsJsr330Statics"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("supportsJsr330Privates", () -> this.supportsJsr330Privates, __META_PROPS.get("supportsJsr330Privates"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("supportsContextualLookup", () -> this.supportsContextualLookup, __META_PROPS.get("supportsContextualLookup"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        }
    }
}

