/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.Metrics;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractMetrics
implements Metrics {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractMetrics.__calcMeta());
    private final Optional<Integer> serviceCount;
    private final Optional<Integer> lookupCount;
    private final Optional<Integer> cacheLookupCount;
    private final Optional<Integer> cacheHitCount;

    protected AbstractMetrics(Builder<?, ?> b) {
        this.serviceCount = b.serviceCount;
        this.lookupCount = b.lookupCount;
        this.cacheLookupCount = b.cacheLookupCount;
        this.cacheHitCount = b.cacheHitCount;
    }

    @Override
    public Optional<Integer> serviceCount() {
        return this.serviceCount;
    }

    @Override
    public Optional<Integer> lookupCount() {
        return this.lookupCount;
    }

    @Override
    public Optional<Integer> cacheLookupCount() {
        return this.cacheLookupCount;
    }

    @Override
    public Optional<Integer> cacheHitCount() {
        return this.cacheHitCount;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("serviceCount", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("lookupCount", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("cacheLookupCount", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("cacheHitCount", Map.of("__type", Optional.class, "__componentType", Integer.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return Metrics.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "serviceCount=" + String.valueOf(this.serviceCount()) + ", ";
        result = (String)result + "lookupCount=" + String.valueOf(this.lookupCount()) + ", ";
        result = (String)result + "cacheLookupCount=" + String.valueOf(this.cacheLookupCount()) + ", ";
        result = (String)result + "cacheHitCount=" + String.valueOf(this.cacheHitCount());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.serviceCount(), this.lookupCount(), this.cacheLookupCount(), this.cacheHitCount());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)another;
        boolean equals = true;
        equals &= Objects.equals(this.serviceCount(), other.serviceCount());
        equals &= Objects.equals(this.lookupCount(), other.lookupCount());
        equals &= Objects.equals(this.cacheLookupCount(), other.cacheLookupCount());
        return equals &= Objects.equals(this.cacheHitCount(), other.cacheHitCount());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("serviceCount", () -> this.serviceCount(), __META_PROPS.get("serviceCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        visitor.visit("lookupCount", () -> this.lookupCount(), __META_PROPS.get("lookupCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        visitor.visit("cacheLookupCount", () -> this.cacheLookupCount(), __META_PROPS.get("cacheLookupCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        visitor.visit("cacheHitCount", () -> this.cacheHitCount(), __META_PROPS.get("cacheHitCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends Metrics>
    implements Metrics,
    io.helidon.common.Builder<B, T> {
        private Optional serviceCount = Optional.empty();
        private Optional lookupCount = Optional.empty();
        private Optional cacheLookupCount = Optional.empty();
        private Optional cacheHitCount = Optional.empty();

        protected Builder() {
        }

        @Override
        public Optional<Integer> serviceCount() {
            return this.serviceCount;
        }

        @Override
        public Optional<Integer> lookupCount() {
            return this.lookupCount;
        }

        @Override
        public Optional<Integer> cacheLookupCount() {
            return this.cacheLookupCount;
        }

        @Override
        public Optional<Integer> cacheHitCount() {
            return this.cacheHitCount;
        }

        public B serviceCount(Optional<Integer> val) {
            this.serviceCount = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B serviceCount(Integer val) {
            Objects.requireNonNull(val);
            return this.serviceCount(Optional.of(val));
        }

        public B lookupCount(Optional<Integer> val) {
            this.lookupCount = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B lookupCount(Integer val) {
            Objects.requireNonNull(val);
            return this.lookupCount(Optional.of(val));
        }

        public B cacheLookupCount(Optional<Integer> val) {
            this.cacheLookupCount = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B cacheLookupCount(Integer val) {
            Objects.requireNonNull(val);
            return this.cacheLookupCount(Optional.of(val));
        }

        public B cacheHitCount(Optional<Integer> val) {
            this.cacheHitCount = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B cacheHitCount(Integer val) {
            Objects.requireNonNull(val);
            return this.cacheHitCount(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.serviceCount(val.serviceCount());
            this.lookupCount(val.lookupCount());
            this.cacheLookupCount(val.cacheLookupCount());
            this.cacheHitCount(val.cacheHitCount());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("serviceCount", () -> this.serviceCount, __META_PROPS.get("serviceCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
            visitor.visit("lookupCount", () -> this.lookupCount, __META_PROPS.get("lookupCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
            visitor.visit("cacheLookupCount", () -> this.cacheLookupCount, __META_PROPS.get("cacheLookupCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
            visitor.visit("cacheHitCount", () -> this.cacheHitCount, __META_PROPS.get("cacheHitCount"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        }
    }
}

