/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementName;
import io.helidon.pico.api.Interceptor;
import io.helidon.pico.api.InvocationContext;
import io.helidon.pico.api.ServiceProvider;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractInvocationContext
implements InvocationContext {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractInvocationContext.__calcMeta());
    private final ServiceProvider<?> serviceProvider;
    private final TypeName serviceTypeName;
    private final List<AnnotationAndValue> classAnnotations;
    private final TypedElementName elementInfo;
    private final Optional<TypedElementName[]> elementArgInfo;
    private final List<Provider<Interceptor>> interceptors;
    private final Map<String, Object> contextData;

    protected AbstractInvocationContext(Builder<?, ?> b) {
        this.serviceProvider = b.serviceProvider;
        this.serviceTypeName = b.serviceTypeName;
        this.classAnnotations = Collections.unmodifiableList(new ArrayList(b.classAnnotations));
        this.elementInfo = b.elementInfo;
        this.elementArgInfo = b.elementArgInfo;
        this.interceptors = Collections.unmodifiableList(new ArrayList(b.interceptors));
        this.contextData = Collections.unmodifiableMap(new LinkedHashMap(b.contextData));
    }

    @Override
    public ServiceProvider<?> serviceProvider() {
        return this.serviceProvider;
    }

    @Override
    public TypeName serviceTypeName() {
        return this.serviceTypeName;
    }

    @Override
    public List<AnnotationAndValue> classAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public TypedElementName elementInfo() {
        return this.elementInfo;
    }

    @Override
    public Optional<TypedElementName[]> elementArgInfo() {
        return this.elementArgInfo;
    }

    @Override
    public List<Provider<Interceptor>> interceptors() {
        return this.interceptors;
    }

    @Override
    public Map<String, Object> contextData() {
        return this.contextData;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("serviceProvider", Map.of("__type", ServiceProvider.class, "__componentType", Object.class));
        metaProps.put("serviceTypeName", Map.of("__type", TypeName.class));
        metaProps.put("classAnnotations", Map.of("__type", List.class, "__componentType", AnnotationAndValue.class));
        metaProps.put("elementInfo", Map.of("__type", TypedElementName.class));
        metaProps.put("elementArgInfo", Map.of("__type", Optional.class, "__componentType", TypedElementName.class));
        metaProps.put("interceptors", Map.of("__type", List.class, "__componentType", Provider.class));
        metaProps.put("contextData", Map.of("__type", Map.class, "__componentType", Object.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return InvocationContext.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "serviceProvider=" + String.valueOf(this.serviceProvider()) + ", ";
        result = (String)result + "serviceTypeName=" + String.valueOf(this.serviceTypeName()) + ", ";
        result = (String)result + "classAnnotations=" + String.valueOf(this.classAnnotations()) + ", ";
        result = (String)result + "elementInfo=" + String.valueOf(this.elementInfo()) + ", ";
        result = (String)result + "elementArgInfo=" + String.valueOf(this.elementArgInfo()) + ", ";
        result = (String)result + "interceptors=" + String.valueOf(this.interceptors()) + ", ";
        result = (String)result + "contextData=" + String.valueOf(this.contextData());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.serviceProvider(), this.serviceTypeName(), this.classAnnotations(), this.elementInfo(), this.elementArgInfo(), this.interceptors(), this.contextData());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof InvocationContext)) {
            return false;
        }
        InvocationContext other = (InvocationContext)another;
        boolean equals = true;
        equals &= Objects.equals(this.serviceProvider(), other.serviceProvider());
        equals &= Objects.equals(this.serviceTypeName(), other.serviceTypeName());
        equals &= Objects.equals(this.classAnnotations(), other.classAnnotations());
        equals &= Objects.equals(this.elementInfo(), other.elementInfo());
        equals &= Objects.equals(this.elementArgInfo(), other.elementArgInfo());
        equals &= Objects.equals(this.interceptors(), other.interceptors());
        return equals &= Objects.equals(this.contextData(), other.contextData());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("serviceProvider", () -> this.serviceProvider(), __META_PROPS.get("serviceProvider"), userDefinedCtx, ServiceProvider.class, new Class[]{Object.class});
        visitor.visit("serviceTypeName", () -> this.serviceTypeName(), __META_PROPS.get("serviceTypeName"), userDefinedCtx, TypeName.class, new Class[0]);
        visitor.visit("classAnnotations", () -> this.classAnnotations(), __META_PROPS.get("classAnnotations"), userDefinedCtx, List.class, new Class[]{AnnotationAndValue.class});
        visitor.visit("elementInfo", () -> this.elementInfo(), __META_PROPS.get("elementInfo"), userDefinedCtx, TypedElementName.class, new Class[0]);
        visitor.visit("elementArgInfo", () -> this.elementArgInfo(), __META_PROPS.get("elementArgInfo"), userDefinedCtx, Optional.class, new Class[]{TypedElementName[].class});
        visitor.visit("interceptors", () -> this.interceptors(), __META_PROPS.get("interceptors"), userDefinedCtx, List.class, new Class[]{Provider.class});
        visitor.visit("contextData", () -> this.contextData(), __META_PROPS.get("contextData"), userDefinedCtx, Map.class, new Class[]{String.class, Object.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends InvocationContext>
    implements InvocationContext,
    io.helidon.common.Builder<B, T> {
        protected final List classAnnotations = new ArrayList();
        protected final List interceptors = new ArrayList();
        protected final Map contextData = new LinkedHashMap();
        private ServiceProvider serviceProvider;
        private TypeName serviceTypeName;
        private TypedElementName elementInfo;
        private Optional elementArgInfo = Optional.empty();

        protected Builder() {
        }

        @Override
        public ServiceProvider<?> serviceProvider() {
            return this.serviceProvider;
        }

        @Override
        public TypeName serviceTypeName() {
            return this.serviceTypeName;
        }

        @Override
        public List<AnnotationAndValue> classAnnotations() {
            return this.classAnnotations;
        }

        @Override
        public TypedElementName elementInfo() {
            return this.elementInfo;
        }

        @Override
        public Optional<TypedElementName[]> elementArgInfo() {
            return this.elementArgInfo;
        }

        @Override
        public List<Provider<Interceptor>> interceptors() {
            return this.interceptors;
        }

        @Override
        public Map<String, Object> contextData() {
            return this.contextData;
        }

        public B serviceProvider(ServiceProvider<?> val) {
            this.serviceProvider = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B serviceTypeName(TypeName val) {
            this.serviceTypeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B classAnnotations(Collection<AnnotationAndValue> val) {
            this.classAnnotations.clear();
            this.classAnnotations.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B elementInfo(TypedElementName val) {
            this.elementInfo = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B elementArgInfo(Optional<TypedElementName[]> val) {
            this.elementArgInfo = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B elementArgInfo(TypedElementName[] val) {
            Objects.requireNonNull(val);
            return this.elementArgInfo(Optional.of(val));
        }

        public B interceptors(Collection<Provider<Interceptor>> val) {
            this.interceptors.clear();
            this.interceptors.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B contextData(Map<String, Object> val) {
            this.contextData.clear();
            this.contextData.putAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.serviceProvider(val.serviceProvider());
            this.serviceTypeName(val.serviceTypeName());
            this.classAnnotations(val.classAnnotations());
            this.elementInfo(val.elementInfo());
            this.elementArgInfo(val.elementArgInfo());
            this.interceptors(val.interceptors());
            this.contextData(val.contextData());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("serviceProvider", () -> this.serviceProvider, __META_PROPS.get("serviceProvider"), userDefinedCtx, ServiceProvider.class, new Class[]{Object.class});
            visitor.visit("serviceTypeName", () -> this.serviceTypeName, __META_PROPS.get("serviceTypeName"), userDefinedCtx, TypeName.class, new Class[0]);
            visitor.visit("classAnnotations", () -> this.classAnnotations, __META_PROPS.get("classAnnotations"), userDefinedCtx, List.class, new Class[]{AnnotationAndValue.class});
            visitor.visit("elementInfo", () -> this.elementInfo, __META_PROPS.get("elementInfo"), userDefinedCtx, TypedElementName.class, new Class[0]);
            visitor.visit("elementArgInfo", () -> this.elementArgInfo, __META_PROPS.get("elementArgInfo"), userDefinedCtx, Optional.class, new Class[]{TypedElementName[].class});
            visitor.visit("interceptors", () -> this.interceptors, __META_PROPS.get("interceptors"), userDefinedCtx, List.class, new Class[]{Provider.class});
            visitor.visit("contextData", () -> this.contextData, __META_PROPS.get("contextData"), userDefinedCtx, Map.class, new Class[]{String.class, Object.class});
        }
    }
}

