/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.Bootstrap;
import io.helidon.pico.api.CallingContext;
import io.helidon.pico.api.InternalBootstrap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

abstract class AbstractInternalBootstrap
extends InternalBootstrap {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractInternalBootstrap.__calcMeta());
    private final Bootstrap bootStrap;
    private final Optional<CallingContext> callingContext;

    protected AbstractInternalBootstrap(Builder<?, ?> b) {
        this.bootStrap = b.bootStrap;
        this.callingContext = b.callingContext;
    }

    @Override
    public Bootstrap bootStrap() {
        return this.bootStrap;
    }

    @Override
    public Optional<CallingContext> callingContext() {
        return this.callingContext;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("bootStrap", Map.of("__type", Bootstrap.class));
        metaProps.put("callingContext", Map.of("__type", Optional.class, "__componentType", CallingContext.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return InternalBootstrap.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "bootStrap=" + String.valueOf(this.bootStrap()) + ", ";
        result = (String)result + "callingContext=" + String.valueOf(this.callingContext());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.bootStrap(), this.callingContext());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof InternalBootstrap)) {
            return false;
        }
        InternalBootstrap other = (InternalBootstrap)another;
        boolean equals = true;
        equals &= Objects.equals(this.bootStrap(), other.bootStrap());
        return equals &= Objects.equals(this.callingContext(), other.callingContext());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("bootStrap", () -> this.bootStrap(), __META_PROPS.get("bootStrap"), userDefinedCtx, Bootstrap.class, new Class[0]);
        visitor.visit("callingContext", () -> this.callingContext(), __META_PROPS.get("callingContext"), userDefinedCtx, Optional.class, new Class[]{CallingContext.class});
    }

    static abstract class Builder<B extends Builder<B, T>, T extends InternalBootstrap>
    extends InternalBootstrap
    implements io.helidon.common.Builder<B, T> {
        private Bootstrap bootStrap;
        private Optional callingContext = Optional.empty();

        protected Builder() {
        }

        @Override
        public Bootstrap bootStrap() {
            return this.bootStrap;
        }

        @Override
        public Optional<CallingContext> callingContext() {
            return this.callingContext;
        }

        public B bootStrap(Bootstrap val) {
            this.bootStrap = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B callingContext(Optional<CallingContext> val) {
            this.callingContext = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B callingContext(CallingContext val) {
            Objects.requireNonNull(val);
            return this.callingContext(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.bootStrap(((InternalBootstrap)val).bootStrap());
            this.callingContext(((InternalBootstrap)val).callingContext());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("bootStrap", () -> this.bootStrap, __META_PROPS.get("bootStrap"), userDefinedCtx, Bootstrap.class, new Class[0]);
            visitor.visit("callingContext", () -> this.callingContext, __META_PROPS.get("callingContext"), userDefinedCtx, Optional.class, new Class[]{CallingContext.class});
        }
    }
}

