/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.ActivationRequest;
import io.helidon.pico.api.Injector;
import io.helidon.pico.api.InjectorOptions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractInjectorOptions
extends InjectorOptions {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractInjectorOptions.__calcMeta());
    private final Injector.Strategy strategy;
    private final ActivationRequest activationRequest;

    protected AbstractInjectorOptions(Builder<?, ?> b) {
        this.strategy = b.strategy;
        this.activationRequest = b.activationRequest;
    }

    @Override
    public Injector.Strategy strategy() {
        return this.strategy;
    }

    @Override
    public ActivationRequest activationRequest() {
        return this.activationRequest;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("strategy", AbstractInjectorOptions.__mapOf("__type", Injector.Strategy.class, "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "ANY", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("activationRequest", Map.of("__type", ActivationRequest.class));
        return metaProps;
    }

    private static Map<String, Object> __mapOf(Object ... args) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            result.put((String)args[i], args[i + 1]);
        }
        return result;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return InjectorOptions.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "strategy=" + String.valueOf((Object)this.strategy()) + ", ";
        result = (String)result + "activationRequest=" + String.valueOf(this.activationRequest());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(new Object[]{this.strategy(), this.activationRequest()});
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof InjectorOptions)) {
            return false;
        }
        InjectorOptions other = (InjectorOptions)another;
        boolean equals = true;
        equals &= Objects.equals((Object)this.strategy(), (Object)other.strategy());
        return equals &= Objects.equals(this.activationRequest(), other.activationRequest());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("strategy", () -> this.strategy(), __META_PROPS.get("strategy"), userDefinedCtx, Injector.Strategy.class, new Class[0]);
        visitor.visit("activationRequest", () -> this.activationRequest(), __META_PROPS.get("activationRequest"), userDefinedCtx, ActivationRequest.class, new Class[0]);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends InjectorOptions>
    extends InjectorOptions
    implements io.helidon.common.Builder<B, T> {
        private Injector.Strategy strategy = Injector.Strategy.ANY;
        private ActivationRequest activationRequest;

        protected Builder() {
        }

        @Override
        public Injector.Strategy strategy() {
            return this.strategy;
        }

        @Override
        public ActivationRequest activationRequest() {
            return this.activationRequest;
        }

        public B strategy(Injector.Strategy val) {
            this.strategy = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B activationRequest(ActivationRequest val) {
            this.activationRequest = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.strategy(((InjectorOptions)val).strategy());
            this.activationRequest(((InjectorOptions)val).activationRequest());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("strategy", () -> this.strategy, __META_PROPS.get("strategy"), userDefinedCtx, Injector.Strategy.class, new Class[0]);
            visitor.visit("activationRequest", () -> this.activationRequest, __META_PROPS.get("activationRequest"), userDefinedCtx, ActivationRequest.class, new Class[0]);
        }
    }
}

