/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.pico.api.AbstractElementInfo;
import io.helidon.pico.api.ElementInfo;
import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.QualifierAndValue;
import io.helidon.pico.api.ServiceInfoCriteria;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractInjectionPointInfo
extends AbstractElementInfo
implements InjectionPointInfo {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractInjectionPointInfo.__calcMeta());
    private final String id;
    private final String baseIdentity;
    private final boolean listWrapped;
    private final boolean optionalWrapped;
    private final boolean providerWrapped;
    private final ServiceInfoCriteria dependencyToServiceInfo;

    protected AbstractInjectionPointInfo(Builder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.baseIdentity = b.baseIdentity;
        this.listWrapped = b.listWrapped;
        this.optionalWrapped = b.optionalWrapped;
        this.providerWrapped = b.providerWrapped;
        this.dependencyToServiceInfo = b.dependencyToServiceInfo;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String baseIdentity() {
        return this.baseIdentity;
    }

    @Override
    public boolean listWrapped() {
        return this.listWrapped;
    }

    @Override
    public boolean optionalWrapped() {
        return this.optionalWrapped;
    }

    @Override
    public boolean providerWrapped() {
        return this.providerWrapped;
    }

    @Override
    public ServiceInfoCriteria dependencyToServiceInfo() {
        return this.dependencyToServiceInfo;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("elementKind", Map.of("__type", ElementInfo.ElementKind.class));
        metaProps.put("access", Map.of("__type", ElementInfo.Access.class));
        metaProps.put("elementTypeName", Map.of("__type", String.class));
        metaProps.put("elementName", Map.of("__type", String.class));
        metaProps.put("elementOffset", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("elementArgs", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("staticDeclaration", Map.of("__type", Boolean.TYPE));
        metaProps.put("serviceTypeName", Map.of("__type", String.class));
        metaProps.put("annotations", Map.of("__type", Set.class, "__componentType", AnnotationAndValue.class));
        metaProps.put("qualifiers", Map.of("__type", Set.class, "__componentType", QualifierAndValue.class));
        metaProps.put("id", Map.of("__type", String.class));
        metaProps.put("baseIdentity", Map.of("__type", String.class));
        metaProps.put("listWrapped", Map.of("__type", Boolean.TYPE));
        metaProps.put("optionalWrapped", Map.of("__type", Boolean.TYPE));
        metaProps.put("providerWrapped", Map.of("__type", Boolean.TYPE));
        metaProps.put("dependencyToServiceInfo", Map.of("__type", ServiceInfoCriteria.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    @Override
    public String toString() {
        return InjectionPointInfo.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    @Override
    protected String toStringInner() {
        Object result = super.toStringInner();
        if (!((String)result).isEmpty() && !((String)result).endsWith(", ")) {
            result = (String)result + ", ";
        }
        result = (String)result + "id=" + this.id() + ", ";
        result = (String)result + "baseIdentity=" + this.baseIdentity() + ", ";
        result = (String)result + "listWrapped=" + this.listWrapped() + ", ";
        result = (String)result + "optionalWrapped=" + this.optionalWrapped() + ", ";
        result = (String)result + "providerWrapped=" + this.providerWrapped() + ", ";
        result = (String)result + "dependencyToServiceInfo=" + String.valueOf(this.dependencyToServiceInfo());
        return result;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + Objects.hash(this.id(), this.baseIdentity(), this.listWrapped(), this.optionalWrapped(), this.providerWrapped(), this.dependencyToServiceInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof InjectionPointInfo)) {
            return false;
        }
        InjectionPointInfo other = (InjectionPointInfo)another;
        boolean equals = super.equals(other);
        equals &= Objects.equals(this.id(), other.id());
        equals &= Objects.equals(this.baseIdentity(), other.baseIdentity());
        equals &= Objects.equals(this.listWrapped(), other.listWrapped());
        equals &= Objects.equals(this.optionalWrapped(), other.optionalWrapped());
        equals &= Objects.equals(this.providerWrapped(), other.providerWrapped());
        return equals &= Objects.equals(this.dependencyToServiceInfo(), other.dependencyToServiceInfo());
    }

    @Override
    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        super.visitAttributes(visitor, userDefinedCtx);
        visitor.visit("id", () -> this.id(), __META_PROPS.get("id"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("baseIdentity", () -> this.baseIdentity(), __META_PROPS.get("baseIdentity"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("listWrapped", () -> this.listWrapped(), __META_PROPS.get("listWrapped"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("optionalWrapped", () -> this.optionalWrapped(), __META_PROPS.get("optionalWrapped"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("providerWrapped", () -> this.providerWrapped(), __META_PROPS.get("providerWrapped"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("dependencyToServiceInfo", () -> this.dependencyToServiceInfo(), __META_PROPS.get("dependencyToServiceInfo"), userDefinedCtx, ServiceInfoCriteria.class, new Class[0]);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends InjectionPointInfo>
    extends AbstractElementInfo.Builder<B, T>
    implements InjectionPointInfo {
        private String id;
        private String baseIdentity;
        private boolean listWrapped;
        private boolean optionalWrapped;
        private boolean providerWrapped;
        private ServiceInfoCriteria dependencyToServiceInfo;

        protected Builder() {
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String baseIdentity() {
            return this.baseIdentity;
        }

        @Override
        public boolean listWrapped() {
            return this.listWrapped;
        }

        @Override
        public boolean optionalWrapped() {
            return this.optionalWrapped;
        }

        @Override
        public boolean providerWrapped() {
            return this.providerWrapped;
        }

        @Override
        public ServiceInfoCriteria dependencyToServiceInfo() {
            return this.dependencyToServiceInfo;
        }

        public B id(String val) {
            this.id = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B baseIdentity(String val) {
            this.baseIdentity = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B listWrapped(boolean val) {
            this.listWrapped = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B optionalWrapped(boolean val) {
            this.optionalWrapped = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B providerWrapped(boolean val) {
            this.providerWrapped = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B dependencyToServiceInfo(ServiceInfoCriteria val) {
            this.dependencyToServiceInfo = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        @Override
        public B accept(T val) {
            Objects.requireNonNull(val);
            super.accept(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.id(val.id());
            this.baseIdentity(val.baseIdentity());
            this.listWrapped(val.listWrapped());
            this.optionalWrapped(val.optionalWrapped());
            this.providerWrapped(val.providerWrapped());
            this.dependencyToServiceInfo(val.dependencyToServiceInfo());
        }

        @Override
        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            super.visitAttributes(visitor, userDefinedCtx);
            visitor.visit("id", () -> this.id, __META_PROPS.get("id"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("baseIdentity", () -> this.baseIdentity, __META_PROPS.get("baseIdentity"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("listWrapped", () -> this.listWrapped, __META_PROPS.get("listWrapped"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("optionalWrapped", () -> this.optionalWrapped, __META_PROPS.get("optionalWrapped"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("providerWrapped", () -> this.providerWrapped, __META_PROPS.get("providerWrapped"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("dependencyToServiceInfo", () -> this.dependencyToServiceInfo, __META_PROPS.get("dependencyToServiceInfo"), userDefinedCtx, ServiceInfoCriteria.class, new Class[0]);
        }
    }
}

