/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.pico.api.ElementInfo;
import io.helidon.pico.api.QualifierAndValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractElementInfo
implements ElementInfo {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractElementInfo.__calcMeta());
    private final ElementInfo.ElementKind elementKind;
    private final ElementInfo.Access access;
    private final String elementTypeName;
    private final String elementName;
    private final Optional<Integer> elementOffset;
    private final Optional<Integer> elementArgs;
    private final boolean staticDeclaration;
    private final String serviceTypeName;
    private final Set<AnnotationAndValue> annotations;
    private final Set<QualifierAndValue> qualifiers;

    protected AbstractElementInfo(Builder<?, ?> b) {
        this.elementKind = b.elementKind;
        this.access = b.access;
        this.elementTypeName = b.elementTypeName;
        this.elementName = b.elementName;
        this.elementOffset = b.elementOffset;
        this.elementArgs = b.elementArgs;
        this.staticDeclaration = b.staticDeclaration;
        this.serviceTypeName = b.serviceTypeName;
        this.annotations = Collections.unmodifiableSet(new LinkedHashSet(b.annotations));
        this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet(b.qualifiers));
    }

    @Override
    public ElementInfo.ElementKind elementKind() {
        return this.elementKind;
    }

    @Override
    public ElementInfo.Access access() {
        return this.access;
    }

    @Override
    public String elementTypeName() {
        return this.elementTypeName;
    }

    @Override
    public String elementName() {
        return this.elementName;
    }

    @Override
    public Optional<Integer> elementOffset() {
        return this.elementOffset;
    }

    @Override
    public Optional<Integer> elementArgs() {
        return this.elementArgs;
    }

    @Override
    public boolean staticDeclaration() {
        return this.staticDeclaration;
    }

    @Override
    public String serviceTypeName() {
        return this.serviceTypeName;
    }

    @Override
    public Set<AnnotationAndValue> annotations() {
        return this.annotations;
    }

    @Override
    public Set<QualifierAndValue> qualifiers() {
        return this.qualifiers;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("elementKind", Map.of("__type", ElementInfo.ElementKind.class));
        metaProps.put("access", Map.of("__type", ElementInfo.Access.class));
        metaProps.put("elementTypeName", Map.of("__type", String.class));
        metaProps.put("elementName", Map.of("__type", String.class));
        metaProps.put("elementOffset", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("elementArgs", Map.of("__type", Optional.class, "__componentType", Integer.class));
        metaProps.put("staticDeclaration", Map.of("__type", Boolean.TYPE));
        metaProps.put("serviceTypeName", Map.of("__type", String.class));
        metaProps.put("annotations", Map.of("__type", Set.class, "__componentType", AnnotationAndValue.class));
        metaProps.put("qualifiers", Map.of("__type", Set.class, "__componentType", QualifierAndValue.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return ElementInfo.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "elementKind=" + String.valueOf((Object)this.elementKind()) + ", ";
        result = (String)result + "access=" + String.valueOf((Object)this.access()) + ", ";
        result = (String)result + "elementTypeName=" + this.elementTypeName() + ", ";
        result = (String)result + "elementName=" + this.elementName() + ", ";
        result = (String)result + "elementOffset=" + String.valueOf(this.elementOffset()) + ", ";
        result = (String)result + "elementArgs=" + String.valueOf(this.elementArgs()) + ", ";
        result = (String)result + "staticDeclaration=" + this.staticDeclaration() + ", ";
        result = (String)result + "serviceTypeName=" + this.serviceTypeName() + ", ";
        result = (String)result + "annotations=" + String.valueOf(this.annotations()) + ", ";
        result = (String)result + "qualifiers=" + String.valueOf(this.qualifiers());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(new Object[]{this.elementKind(), this.access(), this.elementTypeName(), this.elementName(), this.elementOffset(), this.elementArgs(), this.staticDeclaration(), this.serviceTypeName(), this.annotations(), this.qualifiers()});
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ElementInfo)) {
            return false;
        }
        ElementInfo other = (ElementInfo)another;
        boolean equals = true;
        equals &= Objects.equals((Object)this.elementKind(), (Object)other.elementKind());
        equals &= Objects.equals((Object)this.access(), (Object)other.access());
        equals &= Objects.equals(this.elementTypeName(), other.elementTypeName());
        equals &= Objects.equals(this.elementName(), other.elementName());
        equals &= Objects.equals(this.elementOffset(), other.elementOffset());
        equals &= Objects.equals(this.elementArgs(), other.elementArgs());
        equals &= Objects.equals(this.staticDeclaration(), other.staticDeclaration());
        equals &= Objects.equals(this.serviceTypeName(), other.serviceTypeName());
        equals &= Objects.equals(this.annotations(), other.annotations());
        return equals &= Objects.equals(this.qualifiers(), other.qualifiers());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("elementKind", () -> this.elementKind(), __META_PROPS.get("elementKind"), userDefinedCtx, ElementInfo.ElementKind.class, new Class[0]);
        visitor.visit("access", () -> this.access(), __META_PROPS.get("access"), userDefinedCtx, ElementInfo.Access.class, new Class[0]);
        visitor.visit("elementTypeName", () -> this.elementTypeName(), __META_PROPS.get("elementTypeName"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("elementName", () -> this.elementName(), __META_PROPS.get("elementName"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("elementOffset", () -> this.elementOffset(), __META_PROPS.get("elementOffset"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        visitor.visit("elementArgs", () -> this.elementArgs(), __META_PROPS.get("elementArgs"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
        visitor.visit("staticDeclaration", () -> this.staticDeclaration(), __META_PROPS.get("staticDeclaration"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("serviceTypeName", () -> this.serviceTypeName(), __META_PROPS.get("serviceTypeName"), userDefinedCtx, String.class, new Class[0]);
        visitor.visit("annotations", () -> this.annotations(), __META_PROPS.get("annotations"), userDefinedCtx, Set.class, new Class[]{AnnotationAndValue.class});
        visitor.visit("qualifiers", () -> this.qualifiers(), __META_PROPS.get("qualifiers"), userDefinedCtx, Set.class, new Class[]{QualifierAndValue.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ElementInfo>
    implements ElementInfo,
    io.helidon.common.Builder<B, T> {
        protected final Set annotations = new LinkedHashSet();
        protected final Set qualifiers = new LinkedHashSet();
        private ElementInfo.ElementKind elementKind;
        private ElementInfo.Access access;
        private String elementTypeName;
        private String elementName;
        private Optional elementOffset = Optional.empty();
        private Optional elementArgs = Optional.empty();
        private boolean staticDeclaration;
        private String serviceTypeName;

        protected Builder() {
        }

        @Override
        public ElementInfo.ElementKind elementKind() {
            return this.elementKind;
        }

        @Override
        public ElementInfo.Access access() {
            return this.access;
        }

        @Override
        public String elementTypeName() {
            return this.elementTypeName;
        }

        @Override
        public String elementName() {
            return this.elementName;
        }

        @Override
        public Optional<Integer> elementOffset() {
            return this.elementOffset;
        }

        @Override
        public Optional<Integer> elementArgs() {
            return this.elementArgs;
        }

        @Override
        public boolean staticDeclaration() {
            return this.staticDeclaration;
        }

        @Override
        public String serviceTypeName() {
            return this.serviceTypeName;
        }

        @Override
        public Set<AnnotationAndValue> annotations() {
            return this.annotations;
        }

        @Override
        public Set<QualifierAndValue> qualifiers() {
            return this.qualifiers;
        }

        public B elementKind(ElementInfo.ElementKind val) {
            this.elementKind = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B access(ElementInfo.Access val) {
            this.access = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B elementTypeName(String val) {
            this.elementTypeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B elementName(String val) {
            this.elementName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B elementOffset(Optional<Integer> val) {
            this.elementOffset = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B elementOffset(Integer val) {
            Objects.requireNonNull(val);
            return this.elementOffset(Optional.of(val));
        }

        public B elementArgs(Optional<Integer> val) {
            this.elementArgs = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B elementArgs(Integer val) {
            Objects.requireNonNull(val);
            return this.elementArgs(Optional.of(val));
        }

        public B staticDeclaration(boolean val) {
            this.staticDeclaration = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B serviceTypeName(String val) {
            this.serviceTypeName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B annotations(Collection<AnnotationAndValue> val) {
            this.annotations.clear();
            this.annotations.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addAnnotations(Collection<AnnotationAndValue> val) {
            this.annotations.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addAnnotation(AnnotationAndValue val) {
            Objects.requireNonNull(val);
            this.annotations.add(val);
            return (B)((Builder)this.identity());
        }

        public B qualifiers(Collection<QualifierAndValue> val) {
            this.qualifiers.clear();
            this.qualifiers.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addQualifiers(Collection<QualifierAndValue> val) {
            this.qualifiers.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addQualifier(QualifierAndValue val) {
            Objects.requireNonNull(val);
            this.qualifiers.add(val);
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.elementKind(val.elementKind());
            this.access(val.access());
            this.elementTypeName(val.elementTypeName());
            this.elementName(val.elementName());
            this.elementOffset(val.elementOffset());
            this.elementArgs(val.elementArgs());
            this.staticDeclaration(val.staticDeclaration());
            this.serviceTypeName(val.serviceTypeName());
            this.annotations(val.annotations());
            this.qualifiers(val.qualifiers());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("elementKind", () -> this.elementKind, __META_PROPS.get("elementKind"), userDefinedCtx, ElementInfo.ElementKind.class, new Class[0]);
            visitor.visit("access", () -> this.access, __META_PROPS.get("access"), userDefinedCtx, ElementInfo.Access.class, new Class[0]);
            visitor.visit("elementTypeName", () -> this.elementTypeName, __META_PROPS.get("elementTypeName"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("elementName", () -> this.elementName, __META_PROPS.get("elementName"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("elementOffset", () -> this.elementOffset, __META_PROPS.get("elementOffset"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
            visitor.visit("elementArgs", () -> this.elementArgs, __META_PROPS.get("elementArgs"), userDefinedCtx, Optional.class, new Class[]{Integer.class});
            visitor.visit("staticDeclaration", () -> this.staticDeclaration, __META_PROPS.get("staticDeclaration"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("serviceTypeName", () -> this.serviceTypeName, __META_PROPS.get("serviceTypeName"), userDefinedCtx, String.class, new Class[0]);
            visitor.visit("annotations", () -> this.annotations, __META_PROPS.get("annotations"), userDefinedCtx, Set.class, new Class[]{AnnotationAndValue.class});
            visitor.visit("qualifiers", () -> this.qualifiers, __META_PROPS.get("qualifiers"), userDefinedCtx, Set.class, new Class[]{QualifierAndValue.class});
        }
    }
}

