/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.DependencyInfo;
import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.ServiceInfoCriteria;
import io.helidon.pico.api.ServiceProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractDependencyInfo
implements DependencyInfo {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractDependencyInfo.__calcMeta());
    private final ServiceInfoCriteria dependencyTo;
    private final Set<? extends InjectionPointInfo> injectionPointDependencies;
    private final Optional<ServiceProvider<?>> resolvedTo;

    protected AbstractDependencyInfo(Builder<?, ?> b) {
        this.dependencyTo = b.dependencyTo;
        this.injectionPointDependencies = Collections.unmodifiableSet(new LinkedHashSet(b.injectionPointDependencies));
        this.resolvedTo = b.resolvedTo;
    }

    @Override
    public ServiceInfoCriteria dependencyTo() {
        return this.dependencyTo;
    }

    @Override
    public Set<? extends InjectionPointInfo> injectionPointDependencies() {
        return this.injectionPointDependencies;
    }

    @Override
    public Optional<ServiceProvider<?>> resolvedTo() {
        return this.resolvedTo;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("dependencyTo", Map.of("__type", ServiceInfoCriteria.class));
        metaProps.put("injectionPointDependencies", Map.of("__type", Set.class, "__componentType", InjectionPointInfo.class));
        metaProps.put("resolvedTo", Map.of("__type", Optional.class, "__componentType", ServiceProvider.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return DependencyInfo.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "dependencyTo=" + String.valueOf(this.dependencyTo()) + ", ";
        result = (String)result + "injectionPointDependencies=" + String.valueOf(this.injectionPointDependencies()) + ", ";
        result = (String)result + "resolvedTo=" + String.valueOf(this.resolvedTo());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.dependencyTo(), this.injectionPointDependencies(), this.resolvedTo());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof DependencyInfo)) {
            return false;
        }
        DependencyInfo other = (DependencyInfo)another;
        boolean equals = true;
        equals &= Objects.equals(this.dependencyTo(), other.dependencyTo());
        equals &= Objects.equals(this.injectionPointDependencies(), other.injectionPointDependencies());
        return equals &= Objects.equals(this.resolvedTo(), other.resolvedTo());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("dependencyTo", () -> this.dependencyTo(), __META_PROPS.get("dependencyTo"), userDefinedCtx, ServiceInfoCriteria.class, new Class[0]);
        visitor.visit("injectionPointDependencies", () -> this.injectionPointDependencies(), __META_PROPS.get("injectionPointDependencies"), userDefinedCtx, Set.class, new Class[]{InjectionPointInfo.class});
        visitor.visit("resolvedTo", () -> this.resolvedTo(), __META_PROPS.get("resolvedTo"), userDefinedCtx, Optional.class, new Class[]{ServiceProvider.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends DependencyInfo>
    implements DependencyInfo,
    io.helidon.common.Builder<B, T> {
        protected final Set injectionPointDependencies = new LinkedHashSet();
        private ServiceInfoCriteria dependencyTo;
        private Optional resolvedTo = Optional.empty();

        protected Builder() {
        }

        @Override
        public ServiceInfoCriteria dependencyTo() {
            return this.dependencyTo;
        }

        @Override
        public Set<? extends InjectionPointInfo> injectionPointDependencies() {
            return this.injectionPointDependencies;
        }

        @Override
        public Optional<ServiceProvider<?>> resolvedTo() {
            return this.resolvedTo;
        }

        public B dependencyTo(ServiceInfoCriteria val) {
            this.dependencyTo = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B injectionPointDependencies(Collection<? extends InjectionPointInfo> val) {
            this.injectionPointDependencies.clear();
            this.injectionPointDependencies.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addInjectionPointDependencies(Collection<? extends InjectionPointInfo> val) {
            this.injectionPointDependencies.addAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B addInjectionPointDependency(InjectionPointInfo val) {
            Objects.requireNonNull(val);
            this.injectionPointDependencies.add(val);
            return (B)((Builder)this.identity());
        }

        public B resolvedTo(Optional<ServiceProvider<?>> val) {
            this.resolvedTo = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B resolvedTo(ServiceProvider<?> val) {
            Objects.requireNonNull(val);
            return this.resolvedTo(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.dependencyTo(val.dependencyTo());
            this.injectionPointDependencies(val.injectionPointDependencies());
            this.resolvedTo(val.resolvedTo());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("dependencyTo", () -> this.dependencyTo, __META_PROPS.get("dependencyTo"), userDefinedCtx, ServiceInfoCriteria.class, new Class[0]);
            visitor.visit("injectionPointDependencies", () -> this.injectionPointDependencies, __META_PROPS.get("injectionPointDependencies"), userDefinedCtx, Set.class, new Class[]{InjectionPointInfo.class});
            visitor.visit("resolvedTo", () -> this.resolvedTo, __META_PROPS.get("resolvedTo"), userDefinedCtx, Optional.class, new Class[]{ServiceProvider.class});
        }
    }
}

