/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.CallingContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractCallingContext
extends CallingContext {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractCallingContext.__calcMeta());
    private final StackTraceElement[] trace;
    private final Optional<String> moduleName;
    private final String threadName;

    protected AbstractCallingContext(Builder<?, ?> b) {
        this.trace = b.trace;
        this.moduleName = b.moduleName;
        this.threadName = b.threadName;
    }

    @Override
    public StackTraceElement[] trace() {
        return this.trace;
    }

    @Override
    public Optional<String> moduleName() {
        return this.moduleName;
    }

    @Override
    public String threadName() {
        return this.threadName;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("trace", Map.of("__type", StackTraceElement.class));
        metaProps.put("moduleName", Map.of("__type", Optional.class, "__componentType", String.class));
        metaProps.put("threadName", Map.of("__type", String.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "trace=" + String.valueOf(this.trace == null ? "null" : Arrays.asList(this.trace())) + ", ";
        result = (String)result + "moduleName=" + String.valueOf(this.moduleName()) + ", ";
        result = (String)result + "threadName=" + this.threadName();
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.trace(), this.moduleName(), this.threadName());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof CallingContext)) {
            return false;
        }
        CallingContext other = (CallingContext)another;
        boolean equals = true;
        equals &= Arrays.equals(this.trace(), other.trace());
        equals &= Objects.equals(this.moduleName(), other.moduleName());
        return equals &= Objects.equals(this.threadName(), other.threadName());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("trace", () -> this.trace(), __META_PROPS.get("trace"), userDefinedCtx, StackTraceElement[].class, new Class[0]);
        visitor.visit("moduleName", () -> this.moduleName(), __META_PROPS.get("moduleName"), userDefinedCtx, Optional.class, new Class[]{String.class});
        visitor.visit("threadName", () -> this.threadName(), __META_PROPS.get("threadName"), userDefinedCtx, String.class, new Class[0]);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends CallingContext>
    extends CallingContext
    implements io.helidon.common.Builder<B, T> {
        private StackTraceElement[] trace;
        private Optional moduleName = Optional.empty();
        private String threadName;

        protected Builder() {
        }

        @Override
        public StackTraceElement[] trace() {
            return this.trace;
        }

        @Override
        public Optional<String> moduleName() {
            return this.moduleName;
        }

        @Override
        public String threadName() {
            return this.threadName;
        }

        public B trace(StackTraceElement[] val) {
            this.trace = (StackTraceElement[])val.clone();
            return (B)((Builder)this.identity());
        }

        public B moduleName(Optional<String> val) {
            this.moduleName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B moduleName(String val) {
            Objects.requireNonNull(val);
            return this.moduleName(Optional.of(val));
        }

        public B threadName(String val) {
            this.threadName = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.trace(((CallingContext)val).trace());
            this.moduleName(((CallingContext)val).moduleName());
            this.threadName(((CallingContext)val).threadName());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("trace", () -> this.trace, __META_PROPS.get("trace"), userDefinedCtx, StackTraceElement[].class, new Class[0]);
            visitor.visit("moduleName", () -> this.moduleName, __META_PROPS.get("moduleName"), userDefinedCtx, Optional.class, new Class[]{String.class});
            visitor.visit("threadName", () -> this.threadName, __META_PROPS.get("threadName"), userDefinedCtx, String.class, new Class[0]);
        }
    }
}

