/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.common.config.Config;
import io.helidon.pico.api.Bootstrap;
import io.helidon.pico.api.Phase;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractBootstrap
implements Bootstrap {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractBootstrap.__calcMeta());
    private final Optional<Config> config;
    private final Optional<Phase> limitRuntimePhase;

    protected AbstractBootstrap(Builder<?, ?> b) {
        this.config = b.config;
        this.limitRuntimePhase = b.limitRuntimePhase;
    }

    @Override
    public Optional<Config> config() {
        return this.config;
    }

    @Override
    public Optional<Phase> limitRuntimePhase() {
        return this.limitRuntimePhase;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("config", Map.of("__type", Optional.class, "__componentType", Config.class));
        metaProps.put("limitRuntimePhase", Map.of("__type", Optional.class, "__componentType", Phase.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return Bootstrap.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "config=" + String.valueOf(this.config()) + ", ";
        result = (String)result + "limitRuntimePhase=" + String.valueOf(this.limitRuntimePhase());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(this.config(), this.limitRuntimePhase());
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof Bootstrap)) {
            return false;
        }
        Bootstrap other = (Bootstrap)another;
        boolean equals = true;
        equals &= Objects.equals(this.config(), other.config());
        return equals &= Objects.equals(this.limitRuntimePhase(), other.limitRuntimePhase());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("config", () -> this.config(), __META_PROPS.get("config"), userDefinedCtx, Optional.class, new Class[]{Config.class});
        visitor.visit("limitRuntimePhase", () -> this.limitRuntimePhase(), __META_PROPS.get("limitRuntimePhase"), userDefinedCtx, Optional.class, new Class[]{Phase.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends Bootstrap>
    implements Bootstrap,
    io.helidon.common.Builder<B, T> {
        private Optional config = Optional.empty();
        private Optional limitRuntimePhase = Optional.empty();

        protected Builder() {
        }

        @Override
        public Optional<Config> config() {
            return this.config;
        }

        @Override
        public Optional<Phase> limitRuntimePhase() {
            return this.limitRuntimePhase;
        }

        public B config(Optional<Config> val) {
            this.config = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B config(Config val) {
            Objects.requireNonNull(val);
            return this.config(Optional.of(val));
        }

        public B limitRuntimePhase(Optional<Phase> val) {
            this.limitRuntimePhase = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B limitRuntimePhase(Phase val) {
            Objects.requireNonNull(val);
            return this.limitRuntimePhase(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.config(val.config());
            this.limitRuntimePhase(val.limitRuntimePhase());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("config", () -> this.config, __META_PROPS.get("config"), userDefinedCtx, Optional.class, new Class[]{Config.class});
            visitor.visit("limitRuntimePhase", () -> this.limitRuntimePhase, __META_PROPS.get("limitRuntimePhase"), userDefinedCtx, Optional.class, new Class[]{Phase.class});
        }
    }
}

