/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.ActivationResult;
import io.helidon.pico.api.ActivationStatus;
import io.helidon.pico.api.Phase;
import io.helidon.pico.api.ServiceProvider;
import io.helidon.pico.spi.InjectionPlan;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

public abstract class AbstractActivationResult
implements ActivationResult {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractActivationResult.__calcMeta());
    private final ServiceProvider<?> serviceProvider;
    private final Optional<Future<ActivationResult>> finishedActivationResult;
    private final Phase startingActivationPhase;
    private final Phase targetActivationPhase;
    private final Phase finishingActivationPhase;
    private final Optional<ActivationStatus> finishingStatus;
    private final Map<String, ? extends InjectionPlan> injectionPlans;
    private final Map<String, Object> resolvedDependencies;
    private final boolean wasResolved;
    private final Optional<Throwable> error;

    protected AbstractActivationResult(Builder<?, ?> b) {
        this.serviceProvider = b.serviceProvider;
        this.finishedActivationResult = b.finishedActivationResult;
        this.startingActivationPhase = b.startingActivationPhase;
        this.targetActivationPhase = b.targetActivationPhase;
        this.finishingActivationPhase = b.finishingActivationPhase;
        this.finishingStatus = b.finishingStatus;
        this.injectionPlans = Collections.unmodifiableMap(new LinkedHashMap(b.injectionPlans));
        this.resolvedDependencies = Collections.unmodifiableMap(new LinkedHashMap(b.resolvedDependencies));
        this.wasResolved = b.wasResolved;
        this.error = b.error;
    }

    @Override
    public ServiceProvider<?> serviceProvider() {
        return this.serviceProvider;
    }

    @Override
    public Optional<Future<ActivationResult>> finishedActivationResult() {
        return this.finishedActivationResult;
    }

    @Override
    public Phase startingActivationPhase() {
        return this.startingActivationPhase;
    }

    @Override
    public Phase targetActivationPhase() {
        return this.targetActivationPhase;
    }

    @Override
    public Phase finishingActivationPhase() {
        return this.finishingActivationPhase;
    }

    @Override
    public Optional<ActivationStatus> finishingStatus() {
        return this.finishingStatus;
    }

    @Override
    public Map<String, ? extends InjectionPlan> injectionPlans() {
        return this.injectionPlans;
    }

    @Override
    public Map<String, Object> resolvedDependencies() {
        return this.resolvedDependencies;
    }

    @Override
    public boolean wasResolved() {
        return this.wasResolved;
    }

    @Override
    public Optional<Throwable> error() {
        return this.error;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("serviceProvider", Map.of("__type", ServiceProvider.class, "__componentType", Object.class));
        metaProps.put("finishedActivationResult", Map.of("__type", Optional.class, "__componentType", Future.class));
        metaProps.put("startingActivationPhase", Map.of("__type", Phase.class));
        metaProps.put("targetActivationPhase", Map.of("__type", Phase.class));
        metaProps.put("finishingActivationPhase", Map.of("__type", Phase.class));
        metaProps.put("finishingStatus", Map.of("__type", Optional.class, "__componentType", ActivationStatus.class));
        metaProps.put("injectionPlans", Map.of("__type", Map.class, "__componentType", InjectionPlan.class));
        metaProps.put("resolvedDependencies", Map.of("__type", Map.class, "__componentType", Object.class));
        metaProps.put("wasResolved", Map.of("__type", Boolean.TYPE));
        metaProps.put("error", Map.of("__type", Optional.class, "__componentType", Throwable.class));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return ActivationResult.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "serviceProvider=" + String.valueOf(this.serviceProvider()) + ", ";
        result = (String)result + "finishedActivationResult=" + String.valueOf(this.finishedActivationResult()) + ", ";
        result = (String)result + "startingActivationPhase=" + String.valueOf((Object)this.startingActivationPhase()) + ", ";
        result = (String)result + "targetActivationPhase=" + String.valueOf((Object)this.targetActivationPhase()) + ", ";
        result = (String)result + "finishingActivationPhase=" + String.valueOf((Object)this.finishingActivationPhase()) + ", ";
        result = (String)result + "finishingStatus=" + String.valueOf(this.finishingStatus()) + ", ";
        result = (String)result + "injectionPlans=" + String.valueOf(this.injectionPlans()) + ", ";
        result = (String)result + "resolvedDependencies=" + String.valueOf(this.resolvedDependencies()) + ", ";
        result = (String)result + "wasResolved=" + this.wasResolved() + ", ";
        result = (String)result + "error=" + String.valueOf(this.error());
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(new Object[]{this.serviceProvider(), this.finishedActivationResult(), this.startingActivationPhase(), this.targetActivationPhase(), this.finishingActivationPhase(), this.finishingStatus(), this.injectionPlans(), this.resolvedDependencies(), this.wasResolved(), this.error()});
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ActivationResult)) {
            return false;
        }
        ActivationResult other = (ActivationResult)another;
        boolean equals = true;
        equals &= Objects.equals(this.serviceProvider(), other.serviceProvider());
        equals &= Objects.equals(this.finishedActivationResult(), other.finishedActivationResult());
        equals &= Objects.equals((Object)this.startingActivationPhase(), (Object)other.startingActivationPhase());
        equals &= Objects.equals((Object)this.targetActivationPhase(), (Object)other.targetActivationPhase());
        equals &= Objects.equals((Object)this.finishingActivationPhase(), (Object)other.finishingActivationPhase());
        equals &= Objects.equals(this.finishingStatus(), other.finishingStatus());
        equals &= Objects.equals(this.injectionPlans(), other.injectionPlans());
        equals &= Objects.equals(this.resolvedDependencies(), other.resolvedDependencies());
        equals &= Objects.equals(this.wasResolved(), other.wasResolved());
        return equals &= Objects.equals(this.error(), other.error());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("serviceProvider", () -> this.serviceProvider(), __META_PROPS.get("serviceProvider"), userDefinedCtx, ServiceProvider.class, new Class[]{Object.class});
        visitor.visit("finishedActivationResult", () -> this.finishedActivationResult(), __META_PROPS.get("finishedActivationResult"), userDefinedCtx, Optional.class, new Class[]{Future.class});
        visitor.visit("startingActivationPhase", () -> this.startingActivationPhase(), __META_PROPS.get("startingActivationPhase"), userDefinedCtx, Phase.class, new Class[0]);
        visitor.visit("targetActivationPhase", () -> this.targetActivationPhase(), __META_PROPS.get("targetActivationPhase"), userDefinedCtx, Phase.class, new Class[0]);
        visitor.visit("finishingActivationPhase", () -> this.finishingActivationPhase(), __META_PROPS.get("finishingActivationPhase"), userDefinedCtx, Phase.class, new Class[0]);
        visitor.visit("finishingStatus", () -> this.finishingStatus(), __META_PROPS.get("finishingStatus"), userDefinedCtx, Optional.class, new Class[]{ActivationStatus.class});
        visitor.visit("injectionPlans", () -> this.injectionPlans(), __META_PROPS.get("injectionPlans"), userDefinedCtx, Map.class, new Class[]{String.class, InjectionPlan.class});
        visitor.visit("resolvedDependencies", () -> this.resolvedDependencies(), __META_PROPS.get("resolvedDependencies"), userDefinedCtx, Map.class, new Class[]{String.class, Object.class});
        visitor.visit("wasResolved", () -> this.wasResolved(), __META_PROPS.get("wasResolved"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        visitor.visit("error", () -> this.error(), __META_PROPS.get("error"), userDefinedCtx, Optional.class, new Class[]{Throwable.class});
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ActivationResult>
    implements ActivationResult,
    io.helidon.common.Builder<B, T> {
        protected final Map injectionPlans = new LinkedHashMap();
        protected final Map resolvedDependencies = new LinkedHashMap();
        private ServiceProvider serviceProvider;
        private Optional finishedActivationResult = Optional.empty();
        private Phase startingActivationPhase;
        private Phase targetActivationPhase;
        private Phase finishingActivationPhase;
        private Optional finishingStatus = Optional.empty();
        private boolean wasResolved;
        private Optional error = Optional.empty();

        protected Builder() {
        }

        @Override
        public ServiceProvider<?> serviceProvider() {
            return this.serviceProvider;
        }

        @Override
        public Optional<Future<ActivationResult>> finishedActivationResult() {
            return this.finishedActivationResult;
        }

        @Override
        public Phase startingActivationPhase() {
            return this.startingActivationPhase;
        }

        @Override
        public Phase targetActivationPhase() {
            return this.targetActivationPhase;
        }

        @Override
        public Phase finishingActivationPhase() {
            return this.finishingActivationPhase;
        }

        @Override
        public Optional<ActivationStatus> finishingStatus() {
            return this.finishingStatus;
        }

        @Override
        public Map<String, ? extends InjectionPlan> injectionPlans() {
            return this.injectionPlans;
        }

        @Override
        public Map<String, Object> resolvedDependencies() {
            return this.resolvedDependencies;
        }

        @Override
        public boolean wasResolved() {
            return this.wasResolved;
        }

        @Override
        public Optional<Throwable> error() {
            return this.error;
        }

        public B serviceProvider(ServiceProvider<?> val) {
            this.serviceProvider = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B finishedActivationResult(Optional<Future<ActivationResult>> val) {
            this.finishedActivationResult = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B finishedActivationResult(Future<ActivationResult> val) {
            Objects.requireNonNull(val);
            return this.finishedActivationResult(Optional.of(val));
        }

        public B startingActivationPhase(Phase val) {
            this.startingActivationPhase = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B targetActivationPhase(Phase val) {
            this.targetActivationPhase = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B finishingActivationPhase(Phase val) {
            this.finishingActivationPhase = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B finishingStatus(Optional<ActivationStatus> val) {
            this.finishingStatus = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B finishingStatus(ActivationStatus val) {
            Objects.requireNonNull(val);
            return this.finishingStatus(Optional.of(val));
        }

        public B injectionPlans(Map<String, ? extends InjectionPlan> val) {
            this.injectionPlans.clear();
            this.injectionPlans.putAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B resolvedDependencies(Map<String, Object> val) {
            this.resolvedDependencies.clear();
            this.resolvedDependencies.putAll(Objects.requireNonNull(val));
            return (B)((Builder)this.identity());
        }

        public B wasResolved(boolean val) {
            this.wasResolved = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B error(Optional<Throwable> val) {
            this.error = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B error(Throwable val) {
            Objects.requireNonNull(val);
            return this.error(Optional.of(val));
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.serviceProvider(val.serviceProvider());
            this.finishedActivationResult(val.finishedActivationResult());
            this.startingActivationPhase(val.startingActivationPhase());
            this.targetActivationPhase(val.targetActivationPhase());
            this.finishingActivationPhase(val.finishingActivationPhase());
            this.finishingStatus(val.finishingStatus());
            this.injectionPlans(val.injectionPlans());
            this.resolvedDependencies(val.resolvedDependencies());
            this.wasResolved(val.wasResolved());
            this.error(val.error());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("serviceProvider", () -> this.serviceProvider, __META_PROPS.get("serviceProvider"), userDefinedCtx, ServiceProvider.class, new Class[]{Object.class});
            visitor.visit("finishedActivationResult", () -> this.finishedActivationResult, __META_PROPS.get("finishedActivationResult"), userDefinedCtx, Optional.class, new Class[]{Future.class});
            visitor.visit("startingActivationPhase", () -> this.startingActivationPhase, __META_PROPS.get("startingActivationPhase"), userDefinedCtx, Phase.class, new Class[0]);
            visitor.visit("targetActivationPhase", () -> this.targetActivationPhase, __META_PROPS.get("targetActivationPhase"), userDefinedCtx, Phase.class, new Class[0]);
            visitor.visit("finishingActivationPhase", () -> this.finishingActivationPhase, __META_PROPS.get("finishingActivationPhase"), userDefinedCtx, Phase.class, new Class[0]);
            visitor.visit("finishingStatus", () -> this.finishingStatus, __META_PROPS.get("finishingStatus"), userDefinedCtx, Optional.class, new Class[]{ActivationStatus.class});
            visitor.visit("injectionPlans", () -> this.injectionPlans, __META_PROPS.get("injectionPlans"), userDefinedCtx, Map.class, new Class[]{String.class, InjectionPlan.class});
            visitor.visit("resolvedDependencies", () -> this.resolvedDependencies, __META_PROPS.get("resolvedDependencies"), userDefinedCtx, Map.class, new Class[]{String.class, Object.class});
            visitor.visit("wasResolved", () -> this.wasResolved, __META_PROPS.get("wasResolved"), userDefinedCtx, Boolean.TYPE, new Class[0]);
            visitor.visit("error", () -> this.error, __META_PROPS.get("error"), userDefinedCtx, Optional.class, new Class[]{Throwable.class});
        }
    }
}

