/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.ActivationRequest;
import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.Phase;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractActivationRequest
implements ActivationRequest {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractActivationRequest.__calcMeta());
    private final Optional<InjectionPointInfo> injectionPoint;
    private final Optional<Phase> startingPhase;
    private final Phase targetPhase;
    private final boolean throwIfError;

    protected AbstractActivationRequest(Builder<?, ?> b) {
        this.injectionPoint = b.injectionPoint;
        this.startingPhase = b.startingPhase;
        this.targetPhase = b.targetPhase;
        this.throwIfError = b.throwIfError;
    }

    @Override
    public Optional<InjectionPointInfo> injectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public Optional<Phase> startingPhase() {
        return this.startingPhase;
    }

    @Override
    public Phase targetPhase() {
        return this.targetPhase;
    }

    @Override
    public boolean throwIfError() {
        return this.throwIfError;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("injectionPoint", Map.of("__type", Optional.class, "__componentType", InjectionPointInfo.class));
        metaProps.put("startingPhase", Map.of("__type", Optional.class, "__componentType", Phase.class));
        metaProps.put("targetPhase", AbstractActivationRequest.__mapOf("__type", Phase.class, "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "ACTIVE", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        metaProps.put("throwIfError", AbstractActivationRequest.__mapOf("__type", Boolean.TYPE, "type", "io.helidon.config.metadata.ConfiguredOption", "mergeWithParent", "false", "value", "true", "provider", "false", "required", "false", "deprecated", "false", "kind", "VALUE", "experimental", "false"));
        return metaProps;
    }

    private static Map<String, Object> __mapOf(Object ... args) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            result.put((String)args[i], args[i + 1]);
        }
        return result;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return ActivationRequest.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "injectionPoint=" + String.valueOf(this.injectionPoint()) + ", ";
        result = (String)result + "startingPhase=" + String.valueOf(this.startingPhase()) + ", ";
        result = (String)result + "targetPhase=" + String.valueOf((Object)this.targetPhase()) + ", ";
        result = (String)result + "throwIfError=" + this.throwIfError();
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(new Object[]{this.injectionPoint(), this.startingPhase(), this.targetPhase(), this.throwIfError()});
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ActivationRequest)) {
            return false;
        }
        ActivationRequest other = (ActivationRequest)another;
        boolean equals = true;
        equals &= Objects.equals(this.injectionPoint(), other.injectionPoint());
        equals &= Objects.equals(this.startingPhase(), other.startingPhase());
        equals &= Objects.equals((Object)this.targetPhase(), (Object)other.targetPhase());
        return equals &= Objects.equals(this.throwIfError(), other.throwIfError());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("injectionPoint", () -> this.injectionPoint(), __META_PROPS.get("injectionPoint"), userDefinedCtx, Optional.class, new Class[]{InjectionPointInfo.class});
        visitor.visit("startingPhase", () -> this.startingPhase(), __META_PROPS.get("startingPhase"), userDefinedCtx, Optional.class, new Class[]{Phase.class});
        visitor.visit("targetPhase", () -> this.targetPhase(), __META_PROPS.get("targetPhase"), userDefinedCtx, Phase.class, new Class[0]);
        visitor.visit("throwIfError", () -> this.throwIfError(), __META_PROPS.get("throwIfError"), userDefinedCtx, Boolean.TYPE, new Class[0]);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ActivationRequest>
    implements ActivationRequest,
    io.helidon.common.Builder<B, T> {
        private Optional injectionPoint = Optional.empty();
        private Optional startingPhase = Optional.empty();
        private Phase targetPhase = Phase.ACTIVE;
        private boolean throwIfError = true;

        protected Builder() {
        }

        @Override
        public Optional<InjectionPointInfo> injectionPoint() {
            return this.injectionPoint;
        }

        @Override
        public Optional<Phase> startingPhase() {
            return this.startingPhase;
        }

        @Override
        public Phase targetPhase() {
            return this.targetPhase;
        }

        @Override
        public boolean throwIfError() {
            return this.throwIfError;
        }

        public B injectionPoint(Optional<InjectionPointInfo> val) {
            this.injectionPoint = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B injectionPoint(InjectionPointInfo val) {
            Objects.requireNonNull(val);
            return this.injectionPoint(Optional.of(val));
        }

        public B startingPhase(Optional<Phase> val) {
            this.startingPhase = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B startingPhase(Phase val) {
            Objects.requireNonNull(val);
            return this.startingPhase(Optional.of(val));
        }

        public B targetPhase(Phase val) {
            this.targetPhase = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B throwIfError(boolean val) {
            this.throwIfError = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.injectionPoint(val.injectionPoint());
            this.startingPhase(val.startingPhase());
            this.targetPhase(val.targetPhase());
            this.throwIfError(val.throwIfError());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("injectionPoint", () -> this.injectionPoint, __META_PROPS.get("injectionPoint"), userDefinedCtx, Optional.class, new Class[]{InjectionPointInfo.class});
            visitor.visit("startingPhase", () -> this.startingPhase, __META_PROPS.get("startingPhase"), userDefinedCtx, Optional.class, new Class[]{Phase.class});
            visitor.visit("targetPhase", () -> this.targetPhase, __META_PROPS.get("targetPhase"), userDefinedCtx, Phase.class, new Class[0]);
            visitor.visit("throwIfError", () -> this.throwIfError, __META_PROPS.get("throwIfError"), userDefinedCtx, Boolean.TYPE, new Class[0]);
        }
    }
}

