/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.pico.api;

import io.helidon.builder.AttributeVisitor;
import io.helidon.pico.api.ActivationLogEntry;
import io.helidon.pico.api.ActivationResult;
import io.helidon.pico.api.Event;
import io.helidon.pico.api.InjectionPointInfo;
import io.helidon.pico.api.ServiceProvider;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractActivationLogEntry
implements ActivationLogEntry {
    private static final Map<String, Map<String, Object>> __META_PROPS = Collections.unmodifiableMap(AbstractActivationLogEntry.__calcMeta());
    private final Event event;
    private final Optional<String> message;
    private final Optional<ActivationResult> activationResult;
    private final Optional<ServiceProvider<?>> serviceProvider;
    private final Optional<InjectionPointInfo> injectionPoint;
    private final Instant time;
    private final Optional<Throwable> error;
    private final long threadId;

    protected AbstractActivationLogEntry(Builder<?, ?> b) {
        this.event = b.event;
        this.message = b.message;
        this.activationResult = b.activationResult;
        this.serviceProvider = b.serviceProvider;
        this.injectionPoint = b.injectionPoint;
        this.time = b.time;
        this.error = b.error;
        this.threadId = b.threadId;
    }

    @Override
    public Event event() {
        return this.event;
    }

    @Override
    public Optional<String> message() {
        return this.message;
    }

    @Override
    public Optional<ActivationResult> activationResult() {
        return this.activationResult;
    }

    @Override
    public Optional<ServiceProvider<?>> serviceProvider() {
        return this.serviceProvider;
    }

    @Override
    public Optional<InjectionPointInfo> injectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public Instant time() {
        return this.time;
    }

    @Override
    public Optional<Throwable> error() {
        return this.error;
    }

    @Override
    public long threadId() {
        return this.threadId;
    }

    private static Map<String, Map<String, Object>> __calcMeta() {
        LinkedHashMap<String, Map<String, Object>> metaProps = new LinkedHashMap<String, Map<String, Object>>();
        metaProps.put("__generated", Map.of("version", "1"));
        metaProps.put("event", Map.of("__type", Event.class));
        metaProps.put("message", Map.of("__type", Optional.class, "__componentType", String.class));
        metaProps.put("activationResult", Map.of("__type", Optional.class, "__componentType", ActivationResult.class));
        metaProps.put("serviceProvider", Map.of("__type", Optional.class, "__componentType", ServiceProvider.class));
        metaProps.put("injectionPoint", Map.of("__type", Optional.class, "__componentType", InjectionPointInfo.class));
        metaProps.put("time", Map.of("__type", Instant.class));
        metaProps.put("error", Map.of("__type", Optional.class, "__componentType", Throwable.class));
        metaProps.put("threadId", Map.of("__type", Long.TYPE));
        return metaProps;
    }

    public static Map<String, Map<String, Object>> __metaAttributes() {
        return __META_PROPS;
    }

    public String toString() {
        return ActivationLogEntry.class.getSimpleName() + "(" + this.toStringInner() + ")";
    }

    protected String toStringInner() {
        Object result = "";
        result = (String)result + "event=" + String.valueOf((Object)this.event()) + ", ";
        result = (String)result + "message=" + String.valueOf(this.message()) + ", ";
        result = (String)result + "activationResult=" + String.valueOf(this.activationResult()) + ", ";
        result = (String)result + "serviceProvider=" + String.valueOf(this.serviceProvider()) + ", ";
        result = (String)result + "injectionPoint=" + String.valueOf(this.injectionPoint()) + ", ";
        result = (String)result + "time=" + String.valueOf(this.time()) + ", ";
        result = (String)result + "error=" + String.valueOf(this.error()) + ", ";
        result = (String)result + "threadId=" + this.threadId();
        return result;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hash(new Object[]{this.event(), this.message(), this.activationResult(), this.serviceProvider(), this.injectionPoint(), this.time(), this.error(), this.threadId()});
        return hashCode;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ActivationLogEntry)) {
            return false;
        }
        ActivationLogEntry other = (ActivationLogEntry)another;
        boolean equals = true;
        equals &= Objects.equals((Object)this.event(), (Object)other.event());
        equals &= Objects.equals(this.message(), other.message());
        equals &= Objects.equals(this.activationResult(), other.activationResult());
        equals &= Objects.equals(this.serviceProvider(), other.serviceProvider());
        equals &= Objects.equals(this.injectionPoint(), other.injectionPoint());
        equals &= Objects.equals(this.time(), other.time());
        equals &= Objects.equals(this.error(), other.error());
        return equals &= Objects.equals(this.threadId(), other.threadId());
    }

    public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
        visitor.visit("event", () -> this.event(), __META_PROPS.get("event"), userDefinedCtx, Event.class, new Class[0]);
        visitor.visit("message", () -> this.message(), __META_PROPS.get("message"), userDefinedCtx, Optional.class, new Class[]{String.class});
        visitor.visit("activationResult", () -> this.activationResult(), __META_PROPS.get("activationResult"), userDefinedCtx, Optional.class, new Class[]{ActivationResult.class});
        visitor.visit("serviceProvider", () -> this.serviceProvider(), __META_PROPS.get("serviceProvider"), userDefinedCtx, Optional.class, new Class[]{ServiceProvider.class});
        visitor.visit("injectionPoint", () -> this.injectionPoint(), __META_PROPS.get("injectionPoint"), userDefinedCtx, Optional.class, new Class[]{InjectionPointInfo.class});
        visitor.visit("time", () -> this.time(), __META_PROPS.get("time"), userDefinedCtx, Instant.class, new Class[0]);
        visitor.visit("error", () -> this.error(), __META_PROPS.get("error"), userDefinedCtx, Optional.class, new Class[]{Throwable.class});
        visitor.visit("threadId", () -> this.threadId(), __META_PROPS.get("threadId"), userDefinedCtx, Long.TYPE, new Class[0]);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ActivationLogEntry>
    implements ActivationLogEntry,
    io.helidon.common.Builder<B, T> {
        private Event event;
        private Optional message = Optional.empty();
        private Optional activationResult = Optional.empty();
        private Optional serviceProvider = Optional.empty();
        private Optional injectionPoint = Optional.empty();
        private Instant time;
        private Optional error = Optional.empty();
        private long threadId;

        protected Builder() {
        }

        @Override
        public Event event() {
            return this.event;
        }

        @Override
        public Optional<String> message() {
            return this.message;
        }

        @Override
        public Optional<ActivationResult> activationResult() {
            return this.activationResult;
        }

        @Override
        public Optional<ServiceProvider<?>> serviceProvider() {
            return this.serviceProvider;
        }

        @Override
        public Optional<InjectionPointInfo> injectionPoint() {
            return this.injectionPoint;
        }

        @Override
        public Instant time() {
            return this.time;
        }

        @Override
        public Optional<Throwable> error() {
            return this.error;
        }

        @Override
        public long threadId() {
            return this.threadId;
        }

        public B event(Event val) {
            this.event = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B message(Optional<String> val) {
            this.message = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B message(String val) {
            Objects.requireNonNull(val);
            return this.message(Optional.of(val));
        }

        public B activationResult(Optional<ActivationResult> val) {
            this.activationResult = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B activationResult(ActivationResult val) {
            Objects.requireNonNull(val);
            return this.activationResult(Optional.of(val));
        }

        public B serviceProvider(Optional<ServiceProvider<?>> val) {
            this.serviceProvider = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B serviceProvider(ServiceProvider<?> val) {
            Objects.requireNonNull(val);
            return this.serviceProvider(Optional.of(val));
        }

        public B injectionPoint(Optional<InjectionPointInfo> val) {
            this.injectionPoint = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B injectionPoint(InjectionPointInfo val) {
            Objects.requireNonNull(val);
            return this.injectionPoint(Optional.of(val));
        }

        public B time(Instant val) {
            this.time = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B error(Optional<Throwable> val) {
            this.error = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B error(Throwable val) {
            Objects.requireNonNull(val);
            return this.error(Optional.of(val));
        }

        public B threadId(long val) {
            this.threadId = Objects.requireNonNull(val);
            return (B)((Builder)this.identity());
        }

        public B accept(T val) {
            Objects.requireNonNull(val);
            this.__acceptThis(val);
            return (B)((Builder)this.identity());
        }

        private void __acceptThis(T val) {
            Objects.requireNonNull(val);
            this.event(val.event());
            this.message(val.message());
            this.activationResult(val.activationResult());
            this.serviceProvider(val.serviceProvider());
            this.injectionPoint(val.injectionPoint());
            this.time(val.time());
            this.error(val.error());
            this.threadId(val.threadId());
        }

        public <T> void visitAttributes(AttributeVisitor<T> visitor, T userDefinedCtx) {
            visitor.visit("event", () -> this.event, __META_PROPS.get("event"), userDefinedCtx, Event.class, new Class[0]);
            visitor.visit("message", () -> this.message, __META_PROPS.get("message"), userDefinedCtx, Optional.class, new Class[]{String.class});
            visitor.visit("activationResult", () -> this.activationResult, __META_PROPS.get("activationResult"), userDefinedCtx, Optional.class, new Class[]{ActivationResult.class});
            visitor.visit("serviceProvider", () -> this.serviceProvider, __META_PROPS.get("serviceProvider"), userDefinedCtx, Optional.class, new Class[]{ServiceProvider.class});
            visitor.visit("injectionPoint", () -> this.injectionPoint, __META_PROPS.get("injectionPoint"), userDefinedCtx, Optional.class, new Class[]{InjectionPointInfo.class});
            visitor.visit("time", () -> this.time, __META_PROPS.get("time"), userDefinedCtx, Instant.class, new Class[0]);
            visitor.visit("error", () -> this.error, __META_PROPS.get("error"), userDefinedCtx, Optional.class, new Class[]{Throwable.class});
            visitor.visit("threadId", () -> this.threadId, __META_PROPS.get("threadId"), userDefinedCtx, Long.TYPE, new Class[0]);
        }
    }
}

