/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.openapi.CustomConstructor;
import io.helidon.openapi.ExpandedTypeDescription;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public final class OpenAPIParser {
    private OpenAPIParser() {
    }

    public static OpenAPI parse(Map<Class<?>, ExpandedTypeDescription> types, InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            OpenAPI openAPI = OpenAPIParser.parse(types, reader);
            return openAPI;
        }
    }

    static OpenAPI parse(Map<Class<?>, ExpandedTypeDescription> types, Reader reader) {
        TypeDescription openAPITD = types.get(OpenAPI.class);
        CustomConstructor topConstructor = new CustomConstructor(openAPITD);
        types.values().forEach(arg_0 -> ((Constructor)topConstructor).addTypeDescription(arg_0));
        Yaml yaml = new Yaml((BaseConstructor)topConstructor);
        OpenAPI result = (OpenAPI)yaml.loadAs(reader, OpenAPI.class);
        return result;
    }
}

