/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.openapi;

import io.helidon.config.Config;
import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

class OpenAPIConfigImpl
implements OpenApiConfig {
    private final String modelReader;
    private final String filter;
    private final Map<String, Set<String>> operationServers;
    private final Map<String, Set<String>> pathServers;
    private final Boolean scanDisable = Boolean.TRUE;
    private final Set<String> scanPackages = Collections.emptySet();
    private final Set<String> scanClasses = Collections.emptySet();
    private final Set<String> scanExcludePackages = Collections.emptySet();
    private final Set<String> scanExcludeClasses = Collections.emptySet();
    private final Set<String> servers;
    private final Boolean scanDependenciesDisable = Boolean.TRUE;
    private final Set<String> scanDependenciesJars = Collections.emptySet();

    private OpenAPIConfigImpl(Builder builder) {
        this.modelReader = builder.modelReader;
        this.filter = builder.filter;
        this.operationServers = builder.operationServers;
        this.pathServers = builder.pathServers;
        this.servers = new HashSet<String>(builder.servers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String modelReader() {
        return this.modelReader;
    }

    public String filter() {
        return this.filter;
    }

    public boolean scanDisable() {
        return this.scanDisable;
    }

    public Set<String> scanPackages() {
        return this.scanPackages;
    }

    public Set<String> scanClasses() {
        return this.scanClasses;
    }

    public Set<String> scanExcludePackages() {
        return this.scanExcludePackages;
    }

    public Set<String> scanExcludeClasses() {
        return this.scanExcludeClasses;
    }

    public Set<String> servers() {
        return this.servers;
    }

    public Set<String> pathServers(String path) {
        return OpenAPIConfigImpl.chooseEntry(this.pathServers, path);
    }

    public Set<String> operationServers(String operationID) {
        return OpenAPIConfigImpl.chooseEntry(this.operationServers, operationID);
    }

    public boolean scanDependenciesDisable() {
        return this.scanDependenciesDisable;
    }

    public Set<String> scanDependenciesJars() {
        return this.scanDependenciesJars;
    }

    private static <T, U> Set<U> chooseEntry(Map<T, Set<U>> map, T key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return Collections.emptySet();
    }

    public static final class Builder
    implements io.helidon.common.Builder<OpenApiConfig> {
        private static final String CONFIG_PREFIX = "openapi.";
        static final String MODEL_READER = "openapi.model.reader";
        static final String FILTER = "openapi.filter";
        static final String SERVERS = "openapi.servers";
        static final String SERVERS_PATH = "openapi.servers.path";
        static final String SERVERS_OPERATION = "openapi.servers.operation";
        static final List<String> CONFIG_KEYS = Arrays.asList("openapi.model.reader", "openapi.filter", "openapi.servers");
        private String modelReader;
        private String filter;
        private final Map<String, Set<String>> operationServers = new HashMap<String, Set<String>>();
        private final Map<String, Set<String>> pathServers = new HashMap<String, Set<String>>();
        private final Set<String> servers = new HashSet<String>();

        private Builder() {
        }

        public OpenApiConfig build() {
            return new OpenAPIConfigImpl(this);
        }

        public Builder config(Config config) {
            Builder.stringFromConfig(config, MODEL_READER, this::modelReader);
            Builder.stringFromConfig(config, FILTER, this::filter);
            Builder.stringFromConfig(config, SERVERS, this::servers);
            Builder.listFromConfig(config, SERVERS_PATH, this::pathServers);
            Builder.listFromConfig(config, SERVERS_OPERATION, this::operationServers);
            return this;
        }

        public Builder modelReader(String modelReader) {
            this.modelReader = modelReader;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder operationServers(String operationID, String operationServers) {
            this.operationServers.clear();
            Builder.setEntry(this.operationServers, operationID, operationServers);
            return this;
        }

        public Builder addOperationServer(String operationID, String operationServer) {
            Builder.addToEntry(this.operationServers, operationID, operationServer);
            return this;
        }

        public Builder pathServers(String path, String pathServers) {
            Builder.setEntry(this.pathServers, path, pathServers);
            return this;
        }

        public Builder addPathServer(String path, String pathServer) {
            Builder.addToEntry(this.pathServers, path, pathServer);
            return this;
        }

        public Builder servers(String servers) {
            this.servers.clear();
            this.servers.addAll(Builder.commaListToSet(servers));
            return this;
        }

        public Builder addServer(String server) {
            this.servers.add(server);
            return this;
        }

        private static void stringFromConfig(Config config, String key, Function<String, Builder> assignment) {
            config.get(key).ifExists(c -> {
                Builder cfr_ignored_0 = (Builder)assignment.apply((String)c.asString().get());
            });
        }

        private static void listFromConfig(Config config, String keyPrefix, BiFunction<String, String, Builder> assignment) {
            config.get(keyPrefix).ifExists(cf -> ((List)cf.asNodeList().get()).forEach(c -> {
                String key = c.key().name();
                String value = (String)c.asString().get();
                assignment.apply(key, value);
            }));
        }

        private static <T, U> void addToEntry(Map<T, Set<U>> map, T key, U value) {
            Set<Object> set;
            if (map.containsKey(key)) {
                set = map.get(key);
            } else {
                set = new HashSet();
                map.put(key, set);
            }
            set.add(value);
        }

        private static <T> void setEntry(Map<T, Set<String>> map, T key, String values) {
            Set<String> set = Builder.commaListToSet(values);
            map.put(key, set);
        }

        private static Set<String> commaListToSet(String items) {
            HashSet<String> result = new HashSet<String>();
            if (items != null) {
                for (String item : items.split(",")) {
                    result.add(item.trim());
                }
            }
            return result;
        }
    }
}

