/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.tyrus;

import jakarta.websocket.Endpoint;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerApplicationConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class TyrusApplication {
    private Set<Class<? extends ServerApplicationConfig>> applicationClasses;
    private final Set<Class<?>> annotatedEndpoints;
    private final Set<Class<? extends Endpoint>> programmaticEndpoints;
    private final Set<Extension> extensions;

    private TyrusApplication(Builder builder) {
        this.applicationClasses = builder.applicationClasses;
        this.annotatedEndpoints = builder.annotatedEndpoints;
        this.programmaticEndpoints = builder.programmaticEndpoints;
        this.extensions = builder.extensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Class<? extends ServerApplicationConfig>> applicationClass() {
        return this.applicationClasses.isEmpty() ? Optional.empty() : Optional.of(this.applicationClasses.iterator().next());
    }

    public Set<Class<? extends ServerApplicationConfig>> applicationClasses() {
        return Collections.unmodifiableSet(this.applicationClasses);
    }

    public Set<Class<? extends Endpoint>> programmaticEndpoints() {
        return this.programmaticEndpoints;
    }

    public Set<Class<?>> annotatedEndpoints() {
        return this.annotatedEndpoints;
    }

    public Set<Extension> extensions() {
        return this.extensions;
    }

    public static class Builder {
        private static final System.Logger LOGGER = System.getLogger(Builder.class.getName());
        private final Set<Class<? extends ServerApplicationConfig>> applicationClasses = new HashSet<Class<? extends ServerApplicationConfig>>();
        private final Set<Class<?>> annotatedEndpoints = new HashSet();
        private final Set<Class<? extends Endpoint>> programmaticEndpoints = new HashSet<Class<? extends Endpoint>>();
        private final Set<Extension> extensions = new HashSet<Extension>();

        Builder updateApplicationClass(Class<? extends ServerApplicationConfig> applicationClass) {
            if (!this.applicationClasses.isEmpty()) {
                LOGGER.log(System.Logger.Level.DEBUG, () -> "Overriding websocket applications using " + String.valueOf(applicationClass));
            }
            this.applicationClasses.clear();
            this.applicationClasses.add(applicationClass);
            return this;
        }

        public Builder applicationClass(Class<? extends ServerApplicationConfig> applicationClass) {
            this.applicationClasses.add(applicationClass);
            return this;
        }

        public Builder programmaticEndpoint(Class<? extends Endpoint> programmaticEndpoint) {
            this.programmaticEndpoints.add(programmaticEndpoint);
            return this;
        }

        public Builder annotatedEndpoint(Class<?> annotatedEndpoint) {
            this.annotatedEndpoints.add(annotatedEndpoint);
            return this;
        }

        public Builder extension(Extension extension) {
            this.extensions.add(extension);
            return this;
        }

        public TyrusApplication build() {
            return new TyrusApplication(this);
        }
    }
}

