/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.Bulkhead;
import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.Fallback;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandlerTyped;
import io.helidon.faulttolerance.Retry;
import io.helidon.faulttolerance.RetryTimeoutException;
import io.helidon.faulttolerance.Timeout;
import io.helidon.microprofile.faulttolerance.FallbackHelper;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.FtSupplier;
import io.helidon.microprofile.faulttolerance.InvokerAsyncException;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import io.helidon.microprofile.faulttolerance.RequestScopeHelper;
import io.helidon.microprofile.faulttolerance.ThrowableMapper;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;

class MethodInvoker
implements FtSupplier<Object> {
    private final Method method;
    private final InvocationContext context;
    private final MethodIntrospector introspector;
    private static final ConcurrentHashMap<MethodStateKey, MethodState> METHOD_STATES = new ConcurrentHashMap();
    private long handlerStartNanos;
    private long invocationStartNanos;
    private final Context helidonContext;
    private final AtomicBoolean mayInterruptIfRunning = new AtomicBoolean(false);
    private Thread asyncInterruptThread;
    private AtomicBoolean fallbackCalled = new AtomicBoolean(false);
    private final RequestScopeHelper requestScopeHelper;
    private final FtHandlerTyped<Object> handler;
    private final MethodState methodState;

    MethodInvoker(InvocationContext context, MethodIntrospector introspector) {
        this.context = context;
        this.introspector = introspector;
        this.method = context.getMethod();
        this.helidonContext = Contexts.context().orElseGet(Context::create);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Objects.requireNonNull(ccl);
        MethodStateKey methodStateKey = new MethodStateKey(ccl, context.getTarget().getClass(), this.method);
        this.methodState = METHOD_STATES.computeIfAbsent(methodStateKey, key -> {
            MethodState methodState = new MethodState();
            methodState.lastBreakerState = CircuitBreaker.State.CLOSED;
            if (introspector.hasCircuitBreaker()) {
                methodState.breakerTimerOpen = 0L;
                methodState.breakerTimerClosed = 0L;
                methodState.breakerTimerHalfOpen = 0L;
                methodState.startNanos = System.nanoTime();
            }
            this.initMethodHandler(methodState);
            return methodState;
        });
        this.handler = this.createMethodHandler(this.methodState);
        this.requestScopeHelper = new RequestScopeHelper();
        this.requestScopeHelper.saveScope();
        this.registerMetrics();
    }

    private void registerMetrics() {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        if (this.introspector.hasCircuitBreaker()) {
            FaultToleranceMetrics.CircuitBreakerStateTotal.register((Gauge<Long>)((Gauge)() -> this.methodState.breakerTimerOpen), this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerState.OPEN.get());
            FaultToleranceMetrics.CircuitBreakerStateTotal.register((Gauge<Long>)((Gauge)() -> this.methodState.breakerTimerHalfOpen), this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerState.HALF_OPEN.get());
            FaultToleranceMetrics.CircuitBreakerStateTotal.register((Gauge<Long>)((Gauge)() -> this.methodState.breakerTimerClosed), this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerState.CLOSED.get());
            FaultToleranceMetrics.CircuitBreakerOpenedTotal.register(this.introspector.getMethodNameTag());
        }
        if (this.introspector.hasBulkhead()) {
            FaultToleranceMetrics.BulkheadExecutionsRunning.register((Gauge<Long>)((Gauge)() -> this.methodState.bulkhead.stats().concurrentExecutions()), this.introspector.getMethodNameTag());
            if (this.introspector.isAsynchronous()) {
                FaultToleranceMetrics.BulkheadExecutionsWaiting.register((Gauge<Long>)((Gauge)() -> this.methodState.bulkhead.stats().waitingQueueSize()), this.introspector.getMethodNameTag());
            }
        }
    }

    public String toString() {
        String s = super.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(s.substring(s.lastIndexOf(46) + 1)).append(" ").append(this.method.getDeclaringClass().getSimpleName()).append(".").append(this.method.getName()).append("()");
        return sb.toString();
    }

    static void clearMethodStatesMap() {
        METHOD_STATES.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() throws Throwable {
        Supplier<Single> supplier = () -> {
            try {
                return (Single)Contexts.runInContextWithThrow((Context)this.helidonContext, () -> this.handler.invoke(this.toCompletionStageSupplier(() -> ((InvocationContext)this.context).proceed())));
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
        };
        this.updateMetricsBefore();
        if (this.introspector.isAsynchronous()) {
            Single single = supplier.get();
            CompletableFuture asyncFuture = single.toStage(true).toCompletableFuture();
            InvokerCompletableFuture resultFuture = new InvokerCompletableFuture();
            asyncFuture.whenComplete((result, throwable) -> {
                this.requestScopeHelper.clearScope();
                if (throwable != null) {
                    if (throwable instanceof CancellationException) {
                        single.cancel();
                        return;
                    }
                    Throwable cause = throwable instanceof ExecutionException ? ThrowableMapper.map(throwable.getCause()) : ThrowableMapper.map(throwable);
                    this.updateMetricsAfter(cause);
                    resultFuture.completeExceptionally(cause instanceof RetryTimeoutException ? ((RetryTimeoutException)cause).lastRetryException() : cause);
                } else {
                    this.updateMetricsAfter(null);
                    resultFuture.complete(result);
                }
            });
            resultFuture.whenComplete((result, throwable) -> {
                if (throwable instanceof CancellationException) {
                    asyncFuture.cancel(true);
                }
            });
            return resultFuture;
        }
        Object result2 = null;
        Throwable cause = null;
        try {
            Single single = supplier.get();
            CompletableFuture future = single.toStage(true).toCompletableFuture();
            result2 = future.get();
        }
        catch (ExecutionException e) {
            cause = ThrowableMapper.map(e.getCause());
        }
        catch (Throwable t) {
            cause = ThrowableMapper.map(t);
        }
        finally {
            this.requestScopeHelper.clearScope();
        }
        this.updateMetricsAfter(cause);
        if (cause instanceof RetryTimeoutException) {
            throw ((RetryTimeoutException)cause).lastRetryException();
        }
        if (cause != null) {
            throw cause;
        }
        return result2;
    }

    private void initMethodHandler(MethodState methodState) {
        if (this.introspector.hasBulkhead()) {
            methodState.bulkhead = Bulkhead.builder().limit(this.introspector.getBulkhead().value()).queueLength(this.introspector.isAsynchronous() ? this.introspector.getBulkhead().waitingTaskQueue() : 0).cancelSource(false).build();
        }
        if (this.introspector.hasTimeout()) {
            methodState.timeout = Timeout.builder().timeout(Duration.of(this.introspector.getTimeout().value(), this.introspector.getTimeout().unit())).currentThread(!this.introspector.isAsynchronous()).cancelSource(false).build();
        }
        if (this.introspector.hasCircuitBreaker()) {
            methodState.breaker = CircuitBreaker.builder().delay(Duration.of(this.introspector.getCircuitBreaker().delay(), this.introspector.getCircuitBreaker().delayUnit())).successThreshold(this.introspector.getCircuitBreaker().successThreshold()).errorRatio((int)(this.introspector.getCircuitBreaker().failureRatio() * 100.0)).volume(this.introspector.getCircuitBreaker().requestVolumeThreshold()).applyOn((Class[])ThrowableMapper.mapTypes(this.introspector.getCircuitBreaker().failOn())).skipOn((Class[])ThrowableMapper.mapTypes(this.introspector.getCircuitBreaker().skipOn())).build();
        }
    }

    private FtHandlerTyped<Object> createMethodHandler(MethodState methodState) {
        FaultTolerance.TypedBuilder builder = FaultTolerance.typedBuilder();
        if (methodState.bulkhead != null) {
            builder.addBulkhead(methodState.bulkhead);
        }
        if (methodState.timeout != null) {
            builder.addTimeout(methodState.timeout);
        }
        if (methodState.breaker != null) {
            builder.addBreaker(methodState.breaker);
        }
        if (this.introspector.hasRetry()) {
            int maxRetries = this.introspector.getRetry().maxRetries();
            maxRetries = maxRetries == -1 ? Integer.MAX_VALUE : ++maxRetries;
            methodState.retry = Retry.builder().retryPolicy((Retry.RetryPolicy)Retry.JitterRetryPolicy.builder().calls(maxRetries).delay(Duration.of(this.introspector.getRetry().delay(), this.introspector.getRetry().delayUnit())).jitter(Duration.of(this.introspector.getRetry().jitter(), this.introspector.getRetry().jitterDelayUnit())).build()).overallTimeout(Duration.of(this.introspector.getRetry().maxDuration(), this.introspector.getRetry().durationUnit())).applyOn((Class[])ThrowableMapper.mapTypes(this.introspector.getRetry().retryOn())).skipOn((Class[])ThrowableMapper.mapTypes(this.introspector.getRetry().abortOn())).build();
            builder.addRetry(methodState.retry);
        }
        if (this.introspector.hasFallback()) {
            Fallback fallback = Fallback.builder().fallback(throwable -> {
                this.fallbackCalled.set(true);
                FallbackHelper cfb = new FallbackHelper(this.context, this.introspector, (Throwable)throwable);
                return this.toCompletionStageSupplier(cfb::execute).get();
            }).applyOn((Class[])ThrowableMapper.mapTypes(this.introspector.getFallback().applyOn())).skipOn((Class[])ThrowableMapper.mapTypes(this.introspector.getFallback().skipOn())).build();
            builder.addFallback(fallback);
        }
        return builder.build();
    }

    Supplier<? extends CompletionStage<Object>> toCompletionStageSupplier(FtSupplier<Object> supplier) {
        return () -> {
            this.invocationStartNanos = System.nanoTime();
            FtSupplier<Object> wrappedSupplier = this.requestScopeHelper.wrapInScope(supplier);
            CompletableFuture<Object> resultFuture = new CompletableFuture<Object>();
            if (this.introspector.isAsynchronous()) {
                ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                Single single = Async.create().invoke(() -> {
                    try {
                        Thread.currentThread().setContextClassLoader(ccl);
                        this.asyncInterruptThread = Thread.currentThread();
                        return wrappedSupplier.get();
                    }
                    catch (Throwable t) {
                        return new InvokerAsyncException(t);
                    }
                });
                resultFuture.whenComplete((result, throwable) -> {
                    if (throwable instanceof CancellationException) {
                        single.cancel();
                        if (this.mayInterruptIfRunning.get() && this.asyncInterruptThread != null) {
                            this.asyncInterruptThread.interrupt();
                            this.asyncInterruptThread = null;
                        }
                    }
                });
                single.thenAccept(result -> {
                    block5: {
                        try {
                            if (result instanceof InvokerAsyncException) {
                                resultFuture.completeExceptionally(((Exception)result).getCause());
                                break block5;
                            }
                            if (this.method.getReturnType() == Future.class) {
                                resultFuture.complete(result);
                                break block5;
                            }
                            if (result instanceof CompletionStage) {
                                CompletionStage cs = (CompletionStage)result;
                                cs.whenComplete((o, t) -> {
                                    if (t != null) {
                                        resultFuture.completeExceptionally((Throwable)t);
                                    } else {
                                        resultFuture.complete(o);
                                    }
                                });
                                break block5;
                            }
                            throw new InternalError("Return type validation failed for method " + this.method);
                        }
                        catch (Throwable t2) {
                            resultFuture.completeExceptionally(t2);
                        }
                    }
                });
            } else {
                try {
                    resultFuture.complete(wrappedSupplier.get());
                    return resultFuture;
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            }
            return resultFuture;
        };
    }

    private void updateMetricsBefore() {
        this.handlerStartNanos = System.nanoTime();
        if (this.introspector.hasCircuitBreaker()) {
            this.methodState.lock.lock();
            try {
                this.methodState.lastBreakerState = this.methodState.breaker.state();
            }
            finally {
                this.methodState.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetricsAfter(Throwable cause) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        this.methodState.lock.lock();
        try {
            long executionTime = System.nanoTime() - this.handlerStartNanos;
            if (this.introspector.hasRetry()) {
                long retryCounter = this.methodState.retry.retryCounter();
                boolean wasRetried = retryCounter > 0L;
                Counter retryRetriesTotal = FaultToleranceMetrics.RetryRetriesTotal.get(this.introspector.getMethodNameTag());
                if (wasRetried) {
                    retryRetriesTotal.inc(retryCounter);
                }
                if (cause == null) {
                    FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.VALUE_RETURNED.get()).inc();
                } else if (cause instanceof RetryTimeoutException) {
                    FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.MAX_DURATION_REACHED.get()).inc();
                } else {
                    int maxRetries = this.introspector.getRetry().maxRetries();
                    if (maxRetries == -1) {
                        maxRetries = Integer.MAX_VALUE;
                    }
                    if (retryCounter == (long)maxRetries) {
                        FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.MAX_RETRIES_REACHED.get()).inc();
                    } else if (retryCounter < (long)maxRetries) {
                        FaultToleranceMetrics.RetryCallsTotal.get(this.introspector.getMethodNameTag(), wasRetried ? FaultToleranceMetrics.RetryRetried.TRUE.get() : FaultToleranceMetrics.RetryRetried.FALSE.get(), FaultToleranceMetrics.RetryResult.EXCEPTION_NOT_RETRYABLE.get()).inc();
                    }
                }
            }
            if (this.introspector.hasTimeout()) {
                if (cause instanceof org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException) {
                    FaultToleranceMetrics.TimeoutCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.TimeoutTimedOut.TRUE.get()).inc();
                } else {
                    FaultToleranceMetrics.TimeoutCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.TimeoutTimedOut.FALSE.get()).inc();
                }
                FaultToleranceMetrics.TimeoutExecutionDuration.get(this.introspector.getMethodNameTag()).update(executionTime);
            }
            if (this.introspector.hasCircuitBreaker()) {
                Objects.requireNonNull(this.methodState.breaker);
                if (this.methodState.lastBreakerState == CircuitBreaker.State.OPEN) {
                    FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.CIRCUIT_BREAKER_OPEN.get()).inc();
                } else if (this.methodState.breaker.state() == CircuitBreaker.State.OPEN) {
                    FaultToleranceMetrics.CircuitBreakerOpenedTotal.get(this.introspector.getMethodNameTag()).inc();
                }
                if (cause == null) {
                    FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.SUCCESS.get()).inc();
                } else if (!(cause instanceof CircuitBreakerOpenException)) {
                    boolean skipOnThrowable = Arrays.stream(this.introspector.getCircuitBreaker().skipOn()).anyMatch(c -> c.isAssignableFrom(cause.getClass()));
                    boolean failOnThrowable = Arrays.stream(this.introspector.getCircuitBreaker().failOn()).anyMatch(c -> c.isAssignableFrom(cause.getClass()));
                    if (skipOnThrowable || !failOnThrowable) {
                        FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.SUCCESS.get()).inc();
                    } else {
                        FaultToleranceMetrics.CircuitBreakerCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.CircuitBreakerResult.FAILURE.get()).inc();
                    }
                }
                switch (this.methodState.lastBreakerState) {
                    case OPEN: {
                        this.methodState.breakerTimerOpen += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    case CLOSED: {
                        this.methodState.breakerTimerClosed += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    case HALF_OPEN: {
                        this.methodState.breakerTimerHalfOpen += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown breaker state " + this.methodState.lastBreakerState);
                    }
                }
                this.methodState.lastBreakerState = this.methodState.breaker.state();
                this.methodState.startNanos = System.nanoTime();
            }
            if (this.introspector.hasBulkhead()) {
                Objects.requireNonNull(this.methodState.bulkhead);
                Bulkhead.Stats stats = this.methodState.bulkhead.stats();
                Counter bulkheadAccepted = FaultToleranceMetrics.BulkheadCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.BulkheadResult.ACCEPTED.get());
                if (stats.callsAccepted() > bulkheadAccepted.getCount()) {
                    bulkheadAccepted.inc(stats.callsAccepted() - bulkheadAccepted.getCount());
                }
                Counter bulkheadRejected = FaultToleranceMetrics.BulkheadCallsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.BulkheadResult.REJECTED.get());
                if (stats.callsRejected() > bulkheadRejected.getCount()) {
                    bulkheadRejected.inc(stats.callsRejected() - bulkheadRejected.getCount());
                }
                if (!(cause instanceof BulkheadException)) {
                    long waitingTime = this.invocationStartNanos - this.handlerStartNanos;
                    FaultToleranceMetrics.BulkheadRunningDuration.get(this.introspector.getMethodNameTag()).update(executionTime - waitingTime);
                    if (this.introspector.isAsynchronous()) {
                        FaultToleranceMetrics.BulkheadWaitingDuration.get(this.introspector.getMethodNameTag()).update(waitingTime);
                    }
                }
            }
            if (cause == null) {
                FaultToleranceMetrics.InvocationsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.InvocationResult.VALUE_RETURNED.get(), this.introspector.getFallbackTag(this.fallbackCalled.get())).inc();
            } else {
                FaultToleranceMetrics.InvocationsTotal.get(this.introspector.getMethodNameTag(), FaultToleranceMetrics.InvocationResult.EXCEPTION_THROWN.get(), this.introspector.getFallbackTag(this.fallbackCalled.get())).inc();
            }
        }
        finally {
            this.methodState.lock.unlock();
        }
    }

    private static class MethodStateKey {
        private final ClassLoader classLoader;
        private final Class<?> methodClass;
        private final Method method;

        MethodStateKey(ClassLoader classLoader, Class<?> methodClass, Method method) {
            this.classLoader = classLoader;
            this.methodClass = methodClass;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodStateKey that = (MethodStateKey)o;
            return this.classLoader.equals(that.classLoader) && this.methodClass.equals(that.methodClass) && this.method.equals(that.method);
        }

        public int hashCode() {
            return Objects.hash(this.classLoader, this.methodClass, this.method);
        }
    }

    private static class MethodState {
        private Retry retry;
        private Bulkhead bulkhead;
        private CircuitBreaker breaker;
        private Timeout timeout;
        private CircuitBreaker.State lastBreakerState;
        private long breakerTimerOpen;
        private long breakerTimerClosed;
        private long breakerTimerHalfOpen;
        private long startNanos;
        private final ReentrantLock lock = new ReentrantLock();

        private MethodState() {
        }
    }

    class InvokerCompletableFuture<T>
    extends CompletableFuture<T> {
        InvokerCompletableFuture() {
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            Object value = super.get();
            if (MethodInvoker.this.method.getReturnType() == Future.class) {
                return (T)((Future)value).get();
            }
            return value;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object value = super.get(timeout, unit);
            if (MethodInvoker.this.method.getReturnType() == Future.class) {
                return (T)((Future)value).get(timeout, unit);
            }
            return value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            MethodInvoker.this.mayInterruptIfRunning.set(mayInterruptIfRunning);
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

