/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

class FaultToleranceMetrics {
    static final String METRIC_NAME_TEMPLATE = "ft.%s.%s.%s";
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final LazyValue<MetricRegistry> METRIC_REGISTRY = LazyValue.create(() -> (MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[]{new BaseRegistryTypeLiteral()}).get());

    private FaultToleranceMetrics() {
    }

    static boolean enabled() {
        return FaultToleranceMetrics.getMetricRegistry() != null;
    }

    static MetricRegistry getMetricRegistry() {
        return (MetricRegistry)METRIC_REGISTRY.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Gauge<T> registerGauge(Method method, String metricName, String description, Gauge<T> gauge) {
        LOCK.lock();
        try {
            MetricID metricID = new MetricID(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), metricName));
            Gauge existing = (Gauge)FaultToleranceMetrics.getMetricRegistry().getGauges().get(metricID);
            if (existing == null) {
                FaultToleranceMetrics.getMetricRegistry().register(Metadata.builder().withName(metricID.getName()).withDisplayName(metricID.getName()).withDescription(description).withType(MetricType.GAUGE).withUnit("nanoseconds").build(), gauge);
            }
            Gauge gauge2 = existing;
            return gauge2;
        }
        finally {
            LOCK.unlock();
        }
    }

    static class BaseRegistryTypeLiteral
    extends AnnotationLiteral<RegistryType>
    implements RegistryType {
        BaseRegistryTypeLiteral() {
        }

        public MetricRegistry.Type type() {
            return MetricRegistry.Type.BASE;
        }
    }

    static class BulkheadWaitingDuration
    extends FaultToleranceMetric {
        static final BulkheadWaitingDuration INSTANCE = new BulkheadWaitingDuration();

        private BulkheadWaitingDuration() {
        }

        @Override
        String name() {
            return "ft.bulkhead.waitingDuration";
        }

        @Override
        String description() {
            return "Histogram of the time that method executions spent waiting in the queue";
        }

        @Override
        MetricType metricType() {
            return MetricType.HISTOGRAM;
        }

        @Override
        String unit() {
            return "nanoseconds";
        }

        static Histogram get(Tag ... tags) {
            return INSTANCE.registerHistogram(tags);
        }

        static Histogram register(Tag ... tags) {
            return INSTANCE.registerHistogram(tags);
        }
    }

    static class BulkheadRunningDuration
    extends FaultToleranceMetric {
        static final BulkheadRunningDuration INSTANCE = new BulkheadRunningDuration();

        private BulkheadRunningDuration() {
        }

        @Override
        String name() {
            return "ft.bulkhead.runningDuration";
        }

        @Override
        String description() {
            return "Histogram of the time that method executions spent running";
        }

        @Override
        MetricType metricType() {
            return MetricType.HISTOGRAM;
        }

        @Override
        String unit() {
            return "nanoseconds";
        }

        static Histogram get(Tag ... tags) {
            return INSTANCE.registerHistogram(tags);
        }

        static Histogram register(Tag ... tags) {
            return INSTANCE.registerHistogram(tags);
        }
    }

    static class BulkheadExecutionsWaiting
    extends FaultToleranceMetric {
        static final BulkheadExecutionsWaiting INSTANCE = new BulkheadExecutionsWaiting();

        private BulkheadExecutionsWaiting() {
        }

        @Override
        String name() {
            return "ft.bulkhead.executionsWaiting";
        }

        @Override
        String description() {
            return "Number of executions currently waiting in the queue";
        }

        @Override
        MetricType metricType() {
            return MetricType.GAUGE;
        }

        @Override
        String unit() {
            return "none";
        }

        static Gauge<Long> get(Tag ... tags) {
            return INSTANCE.getGauge(tags);
        }

        static Gauge<Long> register(Gauge<Long> gauge, Tag ... tags) {
            return INSTANCE.registerGauge(gauge, tags);
        }
    }

    static class BulkheadExecutionsRunning
    extends FaultToleranceMetric {
        static final BulkheadExecutionsRunning INSTANCE = new BulkheadExecutionsRunning();

        private BulkheadExecutionsRunning() {
        }

        @Override
        String name() {
            return "ft.bulkhead.executionsRunning";
        }

        @Override
        String description() {
            return "Number of currently running executions";
        }

        @Override
        MetricType metricType() {
            return MetricType.GAUGE;
        }

        @Override
        String unit() {
            return "none";
        }

        static Gauge<Long> get(Tag ... tags) {
            return INSTANCE.getGauge(tags);
        }

        static Gauge<Long> register(Gauge<Long> gauge, Tag ... tags) {
            return INSTANCE.registerGauge(gauge, tags);
        }
    }

    static class BulkheadCallsTotal
    extends FaultToleranceMetric {
        static final BulkheadCallsTotal INSTANCE = new BulkheadCallsTotal();

        private BulkheadCallsTotal() {
        }

        @Override
        String name() {
            return "ft.bulkhead.calls.total";
        }

        @Override
        String description() {
            return "The number of times the bulkhead logic was run. This will usually be once per method call, but may be zero times if the circuit breaker prevented execution or more than once if the method call is retried.";
        }

        @Override
        MetricType metricType() {
            return MetricType.COUNTER;
        }

        @Override
        String unit() {
            return "none";
        }

        static Counter get(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }

        static Counter register(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }
    }

    static enum BulkheadResult implements Supplier<Tag>
    {
        ACCEPTED("accepted"),
        REJECTED("rejected");

        private final Tag metricTag;

        private BulkheadResult(String value) {
            this.metricTag = new Tag("bulkheadResult", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static class CircuitBreakerOpenedTotal
    extends FaultToleranceMetric {
        static final CircuitBreakerOpenedTotal INSTANCE = new CircuitBreakerOpenedTotal();

        private CircuitBreakerOpenedTotal() {
        }

        @Override
        String name() {
            return "ft.circuitbreaker.opened.total";
        }

        @Override
        String description() {
            return "Number of times the circuit breaker has moved from closed state to open state";
        }

        @Override
        MetricType metricType() {
            return MetricType.COUNTER;
        }

        @Override
        String unit() {
            return "none";
        }

        static Counter get(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }

        static Counter register(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }
    }

    static class CircuitBreakerStateTotal
    extends FaultToleranceMetric {
        static final CircuitBreakerStateTotal INSTANCE = new CircuitBreakerStateTotal();

        private CircuitBreakerStateTotal() {
        }

        @Override
        String name() {
            return "ft.circuitbreaker.state.total";
        }

        @Override
        String description() {
            return "Amount of time the circuit breaker has spent in each state";
        }

        @Override
        MetricType metricType() {
            return MetricType.GAUGE;
        }

        @Override
        String unit() {
            return "nanoseconds";
        }

        static Gauge<Long> get(Tag ... tags) {
            return INSTANCE.getGauge(tags);
        }

        static Gauge<Long> register(Gauge<Long> gauge, Tag ... tags) {
            return INSTANCE.registerGauge(gauge, tags);
        }
    }

    static class CircuitBreakerCallsTotal
    extends FaultToleranceMetric {
        static final CircuitBreakerCallsTotal INSTANCE = new CircuitBreakerCallsTotal();

        private CircuitBreakerCallsTotal() {
        }

        @Override
        String name() {
            return "ft.circuitbreaker.calls.total";
        }

        @Override
        String description() {
            return "The number of times the circuit breaker logic was run. This will usually be once per method call, but may be more than once if the method call is retried.";
        }

        @Override
        MetricType metricType() {
            return MetricType.COUNTER;
        }

        @Override
        String unit() {
            return "none";
        }

        static Counter get(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }

        static Counter register(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }
    }

    static enum CircuitBreakerState implements Supplier<Tag>
    {
        OPEN("open"),
        CLOSED("closed"),
        HALF_OPEN("halfOpen");

        private final Tag metricTag;

        private CircuitBreakerState(String value) {
            this.metricTag = new Tag("state", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static enum CircuitBreakerResult implements Supplier<Tag>
    {
        SUCCESS("success"),
        FAILURE("failure"),
        CIRCUIT_BREAKER_OPEN("circuitBreakerOpen");

        private final Tag metricTag;

        private CircuitBreakerResult(String value) {
            this.metricTag = new Tag("circuitBreakerResult", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static class TimeoutExecutionDuration
    extends FaultToleranceMetric {
        static final TimeoutExecutionDuration INSTANCE = new TimeoutExecutionDuration();

        private TimeoutExecutionDuration() {
        }

        @Override
        String name() {
            return "ft.timeout.executionDuration";
        }

        @Override
        String description() {
            return "Histogram of execution times for the method";
        }

        @Override
        MetricType metricType() {
            return MetricType.HISTOGRAM;
        }

        @Override
        String unit() {
            return "nanoseconds";
        }

        static Histogram get(Tag ... tags) {
            return INSTANCE.registerHistogram(tags);
        }

        static Histogram register(Tag ... tags) {
            return INSTANCE.registerHistogram(tags);
        }
    }

    static class TimeoutCallsTotal
    extends FaultToleranceMetric {
        static final TimeoutCallsTotal INSTANCE = new TimeoutCallsTotal();

        private TimeoutCallsTotal() {
        }

        @Override
        String name() {
            return "ft.timeout.calls.total";
        }

        @Override
        String description() {
            return "The number of times the timeout logic was run. This will usually be once per method call, but may be zero times if the circuit breaker prevents execution or more than once if the method is retried.";
        }

        @Override
        MetricType metricType() {
            return MetricType.COUNTER;
        }

        @Override
        String unit() {
            return "none";
        }

        static Counter get(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }

        static Counter register(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }
    }

    static enum TimeoutTimedOut implements Supplier<Tag>
    {
        TRUE("true"),
        FALSE("false");

        private final Tag metricTag;

        private TimeoutTimedOut(String value) {
            this.metricTag = new Tag("timedOut", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static class RetryRetriesTotal
    extends FaultToleranceMetric {
        static final RetryRetriesTotal INSTANCE = new RetryRetriesTotal();

        private RetryRetriesTotal() {
        }

        @Override
        String name() {
            return "ft.retry.retries.total";
        }

        @Override
        String description() {
            return "The number of times the method was retried";
        }

        @Override
        MetricType metricType() {
            return MetricType.COUNTER;
        }

        @Override
        String unit() {
            return "none";
        }

        static Counter get(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }

        static Counter register(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }
    }

    static class RetryCallsTotal
    extends FaultToleranceMetric {
        static final RetryCallsTotal INSTANCE = new RetryCallsTotal();

        private RetryCallsTotal() {
        }

        @Override
        String name() {
            return "ft.retry.calls.total";
        }

        @Override
        String description() {
            return "The number of times the retry logic was run. This will always be once per method call.";
        }

        @Override
        MetricType metricType() {
            return MetricType.COUNTER;
        }

        @Override
        String unit() {
            return "none";
        }

        static Counter get(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }

        static Counter register(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }
    }

    static enum RetryRetried implements Supplier<Tag>
    {
        TRUE("true"),
        FALSE("false");

        private final Tag metricTag;

        private RetryRetried(String value) {
            this.metricTag = new Tag("retried", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static enum RetryResult implements Supplier<Tag>
    {
        VALUE_RETURNED("valueReturned"),
        EXCEPTION_NOT_RETRYABLE("exceptionNotRetryable"),
        MAX_RETRIES_REACHED("maxRetriesReached"),
        MAX_DURATION_REACHED("maxDurationReached");

        private final Tag metricTag;

        private RetryResult(String value) {
            this.metricTag = new Tag("retryResult", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static class InvocationsTotal
    extends FaultToleranceMetric {
        static final InvocationsTotal INSTANCE = new InvocationsTotal();

        private InvocationsTotal() {
        }

        @Override
        String name() {
            return "ft.invocations.total";
        }

        @Override
        String description() {
            return "The number of times the method was called";
        }

        @Override
        MetricType metricType() {
            return MetricType.COUNTER;
        }

        @Override
        String unit() {
            return "none";
        }

        static Counter get(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }

        static Counter register(Tag ... tags) {
            return INSTANCE.registerCounter(tags);
        }
    }

    static enum InvocationFallback implements Supplier<Tag>
    {
        APPLIED("applied"),
        NOT_APPLIED("notApplied"),
        NOT_DEFINED("notDefined");

        private final Tag metricTag;

        private InvocationFallback(String value) {
            this.metricTag = new Tag("fallback", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static enum InvocationResult implements Supplier<Tag>
    {
        VALUE_RETURNED("valueReturned"),
        EXCEPTION_THROWN("exceptionThrown");

        private final Tag metricTag;

        private InvocationResult(String value) {
            this.metricTag = new Tag("result", value);
        }

        @Override
        public Tag get() {
            return this.metricTag;
        }
    }

    static abstract class FaultToleranceMetric {
        FaultToleranceMetric() {
        }

        abstract String name();

        abstract String description();

        abstract MetricType metricType();

        abstract String unit();

        protected Counter getCounter(Tag ... tags) {
            MetricID metricID = new MetricID(this.name(), tags);
            return (Counter)FaultToleranceMetrics.getMetricRegistry().getMetrics().get(metricID);
        }

        protected Counter registerCounter(Tag ... tags) {
            Counter counter = this.getCounter(tags);
            if (counter == null) {
                Metadata metadata = Metadata.builder().withName(this.name()).withDisplayName(this.name()).withDescription(this.description()).withType(this.metricType()).withUnit(this.unit()).build();
                try {
                    counter = FaultToleranceMetrics.getMetricRegistry().counter(metadata, tags);
                }
                catch (IllegalArgumentException e) {
                    counter = this.getCounter(tags);
                    Objects.requireNonNull(counter);
                }
            }
            return counter;
        }

        protected Histogram getHistogram(Tag ... tags) {
            MetricID metricID = new MetricID(this.name(), tags);
            return (Histogram)FaultToleranceMetrics.getMetricRegistry().getMetrics().get(metricID);
        }

        protected Histogram registerHistogram(Tag ... tags) {
            Histogram histogram = this.getHistogram(tags);
            if (histogram == null) {
                Metadata metadata = Metadata.builder().withName(this.name()).withDisplayName(this.name()).withDescription(this.description()).withType(this.metricType()).withUnit(this.unit()).build();
                try {
                    histogram = FaultToleranceMetrics.getMetricRegistry().histogram(metadata, tags);
                }
                catch (IllegalArgumentException e) {
                    histogram = this.getHistogram(tags);
                    Objects.requireNonNull(histogram);
                }
            }
            return histogram;
        }

        protected <T> Gauge<T> getGauge(Tag ... tags) {
            MetricID metricID = new MetricID(this.name(), tags);
            return (Gauge)FaultToleranceMetrics.getMetricRegistry().getMetrics().get(metricID);
        }

        static <T extends Metric> T getMetric(Method method, String name) {
            MetricID metricID = new MetricID(String.format(FaultToleranceMetrics.METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), name));
            return (T)((Metric)FaultToleranceMetrics.getMetricRegistry().getMetrics().get(metricID));
        }

        static Counter getCounter(Method method, String name) {
            return (Counter)FaultToleranceMetric.getMetric(method, name);
        }

        static Histogram getHistogram(Method method, String name) {
            return (Histogram)FaultToleranceMetric.getMetric(method, name);
        }

        static <T> Gauge<T> getGauge(Method method, String name) {
            return (Gauge)FaultToleranceMetric.getMetric(method, name);
        }

        static long getCounter(Object bean, String methodName, String name, Class<?> ... params) throws Exception {
            Method method = FaultToleranceMetric.findMethod(FaultToleranceExtension.getRealClass(bean), methodName, params);
            return FaultToleranceMetric.getCounter(method, name).getCount();
        }

        static Histogram getHistogram(Object bean, String methodName, String name, Class<?> ... params) throws Exception {
            Method method = FaultToleranceMetric.findMethod(FaultToleranceExtension.getRealClass(bean), methodName, params);
            return FaultToleranceMetric.getHistogram(method, name);
        }

        static <T> Gauge<T> getGauge(Object bean, String methodName, String name, Class<?> ... params) throws Exception {
            Method method = FaultToleranceMetric.findMethod(FaultToleranceExtension.getRealClass(bean), methodName, params);
            return FaultToleranceMetric.getGauge(method, name);
        }

        private static Method findMethod(Class<?> beanClass, String methodName, Class<?> ... params) throws NoSuchMethodException {
            try {
                Method method = beanClass.getDeclaredMethod(methodName, params);
                method.setAccessible(true);
                return method;
            }
            catch (Exception e) {
                return beanClass.getMethod(methodName, params);
            }
        }

        protected <T> Gauge<T> registerGauge(Gauge<T> newGauge, Tag ... tags) {
            Gauge gauge = this.getGauge(tags);
            if (gauge == null) {
                Metadata metadata = Metadata.builder().withName(this.name()).withDisplayName(this.name()).withDescription(this.description()).withType(this.metricType()).withUnit(this.unit()).build();
                try {
                    gauge = (Gauge)FaultToleranceMetrics.getMetricRegistry().register(metadata, newGauge, tags);
                }
                catch (IllegalArgumentException e) {
                    gauge = this.getGauge(tags);
                    Objects.requireNonNull(gauge);
                }
            }
            return gauge;
        }
    }
}

