/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.AnnotationFinder;
import io.helidon.microprofile.faulttolerance.FaultToleranceParameter;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.faulttolerance.Retry;

abstract class MethodAntn {
    private static final Logger LOGGER = Logger.getLogger(MethodAntn.class.getName());
    private static final AnnotationFinder ANNOTATION_FINDER = AnnotationFinder.create(Retry.class.getPackage());
    private final AnnotatedType<?> annotatedType;
    private final AnnotatedMethod<?> annotatedMethod;

    MethodAntn(AnnotatedMethod<?> annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
        this.annotatedType = annotatedMethod.getDeclaringType();
    }

    Method method() {
        return this.annotatedMethod.getJavaMember();
    }

    public final <A extends Annotation> LookupResult<A> lookupAnnotation(Class<A> annotClass) {
        return MethodAntn.lookupAnnotation(this.annotatedMethod, annotClass, null);
    }

    static boolean isAnnotationPresent(AnnotatedMethod<?> annotatedMethod, Class<? extends Annotation> annotClass, BeanManager beanManager) {
        return MethodAntn.lookupAnnotation(annotatedMethod, annotClass, beanManager) != null;
    }

    public abstract void validate();

    public Class<? extends Annotation> annotationType() {
        return this.getClass().getInterfaces()[0];
    }

    protected String getParamOverride(String parameter, MatchingType type) {
        String value;
        String annotationType = this.getClass().getInterfaces()[0].getSimpleName();
        if (type == MatchingType.METHOD ? (value = FaultToleranceParameter.getParameter(this.method().getDeclaringClass().getName(), this.method().getName(), annotationType, parameter)) != null : type == MatchingType.CLASS && (value = FaultToleranceParameter.getParameter(this.method().getDeclaringClass().getName(), annotationType, parameter)) != null) {
            return value;
        }
        value = FaultToleranceParameter.getParameter(annotationType, parameter);
        if (value != null) {
            return value;
        }
        return null;
    }

    static Class<? extends Throwable>[] parseThrowableArray(String array) {
        ArrayList result = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(array, "{}, \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            try {
                String className = tokenizer.nextToken();
                if (className.endsWith(".class")) {
                    className = className.substring(0, className.length() - ".class".length());
                }
                result.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result.toArray(new Class[0]);
    }

    static <A extends Annotation> LookupResult<A> lookupAnnotation(AnnotatedMethod<?> method, Class<A> annotClass, BeanManager beanManager) {
        Annotation annotation = MethodAntn.getMethodAnnotation(method, annotClass, beanManager);
        if (annotation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found annotation '" + annotClass.getName() + "' method '" + method.getJavaMember().getName() + "'");
            }
            return new LookupResult<Annotation>(MatchingType.METHOD, annotation);
        }
        AnnotatedType type = method.getDeclaringType();
        annotation = MethodAntn.getClassAnnotation(type, annotClass, beanManager);
        if (annotation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found annotation '" + annotClass.getName() + "' class '" + method.getJavaMember().getDeclaringClass().getName() + "'");
            }
            return new LookupResult<Annotation>(MatchingType.CLASS, annotation);
        }
        annotation = MethodAntn.getClassAnnotation(method.getJavaMember().getDeclaringClass(), annotClass, beanManager);
        if (annotation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found annotation '" + annotClass.getName() + "' class '" + method.getJavaMember().getDeclaringClass().getName() + "'");
            }
            return new LookupResult<Annotation>(MatchingType.CLASS, annotation);
        }
        return null;
    }

    private static Annotation getMethodAnnotation(AnnotatedMethod<?> m, Class<? extends Annotation> annotClass, BeanManager beanManager) {
        Set<Annotation> set = ANNOTATION_FINDER.findAnnotations(m.getAnnotations(), beanManager);
        return set.stream().filter(a -> a.annotationType().equals(annotClass)).findFirst().orElse(null);
    }

    private static Annotation getClassAnnotation(Class<?> c, Class<? extends Annotation> annotClass, BeanManager beanManager) {
        Set<Annotation> set = ANNOTATION_FINDER.findAnnotations(Set.of(c.getAnnotations()), beanManager);
        return set.stream().filter(a -> a.annotationType().equals(annotClass)).findFirst().orElse(null);
    }

    private static Annotation getClassAnnotation(AnnotatedType<?> type, Class<? extends Annotation> annotClass, BeanManager beanManager) {
        Set<Annotation> set = ANNOTATION_FINDER.findAnnotations(type.getAnnotations(), beanManager);
        return set.stream().filter(a -> a.annotationType().equals(annotClass)).findFirst().orElse(null);
    }

    static class LookupResult<A extends Annotation> {
        private final MatchingType type;
        private final A annotation;

        LookupResult(MatchingType type, A annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        public MatchingType getType() {
            return this.type;
        }

        public A getAnnotation() {
            return this.annotation;
        }
    }

    static enum MatchingType {
        METHOD,
        CLASS;

    }
}

