/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.MethodAntn;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

class TimeoutAntn
extends MethodAntn
implements Timeout {
    TimeoutAntn(Class<?> beanClass, Method method) {
        super(beanClass, method);
    }

    @Override
    public void validate() {
        if (this.value() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Timeout annotation, value must be >= 0");
        }
    }

    public long value() {
        MethodAntn.LookupResult<Timeout> lookupResult = this.lookupAnnotation(Timeout.class);
        String override = this.getParamOverride("value", lookupResult.getType());
        return override != null ? Long.parseLong(override) : lookupResult.getAnnotation().value();
    }

    public ChronoUnit unit() {
        MethodAntn.LookupResult<Timeout> lookupResult = this.lookupAnnotation(Timeout.class);
        String override = this.getParamOverride("unit", lookupResult.getType());
        return override != null ? ChronoUnit.valueOf(override) : lookupResult.getAnnotation().unit();
    }
}

