/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.MethodAntn;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

class RetryAntn
extends MethodAntn
implements Retry {
    RetryAntn(Class<?> beanClass, Method method) {
        super(beanClass, method);
    }

    @Override
    public void validate() {
        if (this.maxRetries() < -1) {
            throw new FaultToleranceDefinitionException("Invalid @Retry annotation, maxRetries must be >= -1");
        }
        if (this.delay() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry annotation, delay must be >= 0");
        }
        Duration delay = Duration.of(this.delay(), this.delayUnit());
        Duration maxDuration = Duration.of(this.maxDuration(), this.durationUnit());
        if (maxDuration.compareTo(delay) < 0) {
            throw new FaultToleranceDefinitionException("Invalid @Retry annotation, maxDuration must be >= delay");
        }
        if (this.jitter() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry annotation, jitter must be >= 0");
        }
    }

    public int maxRetries() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("maxRetries", lookupResult.getType());
        return override != null ? Integer.parseInt(override) : lookupResult.getAnnotation().maxRetries();
    }

    public long delay() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("delay", lookupResult.getType());
        return override != null ? Long.parseLong(override) : lookupResult.getAnnotation().delay();
    }

    public ChronoUnit delayUnit() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("delayUnit", lookupResult.getType());
        return override != null ? ChronoUnit.valueOf(override) : lookupResult.getAnnotation().delayUnit();
    }

    public long maxDuration() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("maxDuration", lookupResult.getType());
        return override != null ? Long.parseLong(override) : lookupResult.getAnnotation().maxDuration();
    }

    public ChronoUnit durationUnit() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("durationUnit", lookupResult.getType());
        return override != null ? ChronoUnit.valueOf(override) : lookupResult.getAnnotation().durationUnit();
    }

    public long jitter() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("jitter", lookupResult.getType());
        return override != null ? Long.parseLong(override) : lookupResult.getAnnotation().jitter();
    }

    public ChronoUnit jitterDelayUnit() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("jitterDelayUnit", lookupResult.getType());
        return override != null ? ChronoUnit.valueOf(override) : lookupResult.getAnnotation().jitterDelayUnit();
    }

    public Class<? extends Throwable>[] retryOn() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("retryOn", lookupResult.getType());
        return override != null ? RetryAntn.parseThrowableArray(override) : lookupResult.getAnnotation().retryOn();
    }

    public Class<? extends Throwable>[] abortOn() {
        MethodAntn.LookupResult<Retry> lookupResult = this.lookupAnnotation(Retry.class);
        String override = this.getParamOverride("abortOn", lookupResult.getType());
        return override != null ? RetryAntn.parseThrowableArray(override) : lookupResult.getAnnotation().abortOn();
    }
}

