/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.CommandBinding;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import io.helidon.microprofile.faulttolerance.MethodInvoker;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.logging.Logger;

@Interceptor
@CommandBinding
@Priority(value=4010)
class CommandInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CommandInterceptor.class.getName());

    CommandInterceptor() {
    }

    @AroundInvoke
    public Object interceptCommand(InvocationContext context) throws Throwable {
        try {
            LOGGER.fine("Interceptor called for '" + context.getTarget().getClass() + "::" + context.getMethod().getName() + "'");
            MethodIntrospector introspector = new MethodIntrospector(context.getTarget().getClass(), context.getMethod());
            MethodInvoker runner = new MethodInvoker(context, introspector);
            return runner.get();
        }
        catch (Throwable t) {
            LOGGER.fine("Throwable caught by interceptor '" + t.getMessage() + "'");
            throw t;
        }
    }
}

