/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;

class FtAnnotatedMethod
implements AnnotatedMethod<Object> {
    private final Method method;
    private final AnnotatedType<Object> type;

    FtAnnotatedMethod(final Method method) {
        this.method = method;
        this.type = new AnnotatedType<Object>(){
            private final Class<?> clazz;
            {
                this.clazz = method.getDeclaringClass();
            }

            public Class<Object> getJavaClass() {
                return this.clazz;
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                return this.clazz.getAnnotation(annotationType);
            }

            public Set<Annotation> getAnnotations() {
                return Set.of(this.clazz.getAnnotations());
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                return this.clazz.isAnnotationPresent(annotationType);
            }

            public Set<AnnotatedConstructor<Object>> getConstructors() {
                throw new IllegalStateException("Should not be called");
            }

            public Set<AnnotatedMethod<? super Object>> getMethods() {
                throw new IllegalStateException("Should not be called");
            }

            public Set<AnnotatedField<? super Object>> getFields() {
                throw new IllegalStateException("Should not be called");
            }

            public Type getBaseType() {
                throw new IllegalStateException("Should not be called");
            }

            public Set<Type> getTypeClosure() {
                throw new IllegalStateException("Should not be called");
            }
        };
    }

    public Method getJavaMember() {
        return this.method;
    }

    public AnnotatedType<Object> getDeclaringType() {
        return this.type;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        Set<T> set = this.getAnnotations(annotationType);
        return (T)(set.isEmpty() ? null : (Annotation)set.iterator().next());
    }

    public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
        Annotation[] annotationsByType = this.getJavaMember().getAnnotationsByType(annotationType);
        return new LinkedHashSet<Annotation>(Arrays.asList(annotationsByType));
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getJavaMember().isAnnotationPresent(annotationType);
    }

    public Set<Annotation> getAnnotations() {
        Annotation[] annotations = this.getJavaMember().getAnnotations();
        return new LinkedHashSet<Annotation>(Arrays.asList(annotations));
    }

    public Type getBaseType() {
        throw new IllegalStateException("Should not be called");
    }

    public Set<Type> getTypeClosure() {
        throw new IllegalStateException("Should not be called");
    }

    public List<AnnotatedParameter<Object>> getParameters() {
        throw new IllegalStateException("Should not be called");
    }

    public boolean isStatic() {
        throw new IllegalStateException("Should not be called");
    }
}

