/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

class FaultToleranceMetrics {
    static final String METRIC_NAME_TEMPLATE = "ft.%s.%s.%s";
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final LazyValue<MetricRegistry> METRIC_REGISTRY = LazyValue.create(() -> (MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[0]).get());
    static final String INVOCATIONS_TOTAL = "invocations.total";
    static final String INVOCATIONS_FAILED_TOTAL = "invocations.failed.total";
    static final String RETRY_CALLS_SUCCEEDED_NOT_RETRIED_TOTAL = "retry.callsSucceededNotRetried.total";
    static final String RETRY_CALLS_SUCCEEDED_RETRIED_TOTAL = "retry.callsSucceededRetried.total";
    static final String RETRY_CALLS_FAILED_TOTAL = "retry.callsFailed.total";
    static final String RETRY_RETRIES_TOTAL = "retry.retries.total";
    static final String TIMEOUT_EXECUTION_DURATION = "timeout.executionDuration";
    static final String TIMEOUT_CALLS_TIMED_OUT_TOTAL = "timeout.callsTimedOut.total";
    static final String TIMEOUT_CALLS_NOT_TIMED_OUT_TOTAL = "timeout.callsNotTimedOut.total";
    static final String BREAKER_CALLS_SUCCEEDED_TOTAL = "circuitbreaker.callsSucceeded.total";
    static final String BREAKER_CALLS_FAILED_TOTAL = "circuitbreaker.callsFailed.total";
    static final String BREAKER_CALLS_PREVENTED_TOTAL = "circuitbreaker.callsPrevented.total";
    static final String BREAKER_OPENED_TOTAL = "circuitbreaker.opened.total";
    static final String BREAKER_OPEN_TOTAL = "circuitbreaker.open.total";
    static final String BREAKER_CLOSED_TOTAL = "circuitbreaker.closed.total";
    static final String BREAKER_HALF_OPEN_TOTAL = "circuitbreaker.halfOpen.total";
    static final String FALLBACK_CALLS_TOTAL = "fallback.calls.total";
    static final String BULKHEAD_CONCURRENT_EXECUTIONS = "bulkhead.concurrentExecutions";
    static final String BULKHEAD_CALLS_ACCEPTED_TOTAL = "bulkhead.callsAccepted.total";
    static final String BULKHEAD_CALLS_REJECTED_TOTAL = "bulkhead.callsRejected.total";
    static final String BULKHEAD_EXECUTION_DURATION = "bulkhead.executionDuration";
    static final String BULKHEAD_WAITING_QUEUE_POPULATION = "bulkhead.waitingQueue.population";
    static final String BULKHEAD_WAITING_DURATION = "bulkhead.waiting.duration";

    private FaultToleranceMetrics() {
    }

    static boolean enabled() {
        return FaultToleranceMetrics.getMetricRegistry() != null;
    }

    static MetricRegistry getMetricRegistry() {
        return (MetricRegistry)METRIC_REGISTRY.get();
    }

    static <T extends Metric> T getMetric(Method method, String name) {
        MetricID metricID = FaultToleranceMetrics.newMetricID(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), name));
        return (T)((Metric)FaultToleranceMetrics.getMetricRegistry().getMetrics().get(metricID));
    }

    static Counter getCounter(Method method, String name) {
        return (Counter)FaultToleranceMetrics.getMetric(method, name);
    }

    static Histogram getHistogram(Method method, String name) {
        return (Histogram)FaultToleranceMetrics.getMetric(method, name);
    }

    static <T> Gauge<T> getGauge(Method method, String name) {
        return (Gauge)FaultToleranceMetrics.getMetric(method, name);
    }

    static long getCounter(Object bean, String methodName, String name, Class<?> ... params) throws Exception {
        Method method = FaultToleranceMetrics.findMethod(FaultToleranceExtension.getRealClass(bean), methodName, params);
        return FaultToleranceMetrics.getCounter(method, name).getCount();
    }

    static Histogram getHistogram(Object bean, String methodName, String name, Class<?> ... params) throws Exception {
        Method method = FaultToleranceMetrics.findMethod(FaultToleranceExtension.getRealClass(bean), methodName, params);
        return FaultToleranceMetrics.getHistogram(method, name);
    }

    static <T> Gauge<T> getGauge(Object bean, String methodName, String name, Class<?> ... params) throws Exception {
        Method method = FaultToleranceMetrics.findMethod(FaultToleranceExtension.getRealClass(bean), methodName, params);
        return FaultToleranceMetrics.getGauge(method, name);
    }

    private static Method findMethod(Class<?> beanClass, String methodName, Class<?> ... params) throws NoSuchMethodException {
        try {
            Method method = beanClass.getDeclaredMethod(methodName, params);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            return beanClass.getMethod(methodName, params);
        }
    }

    static void registerMetrics(Method method) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), INVOCATIONS_TOTAL), "The number of times the method was called");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), INVOCATIONS_FAILED_TOTAL), "The number of times the method was called and, after all Fault Tolerance actions had been processed, threw a Throwable");
    }

    static void registerRetryMetrics(Method method) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), RETRY_CALLS_SUCCEEDED_NOT_RETRIED_TOTAL), "The number of times the method was called and succeeded without retrying");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), RETRY_CALLS_SUCCEEDED_RETRIED_TOTAL), "The number of times the method was called and succeeded after retrying at least once");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), RETRY_CALLS_FAILED_TOTAL), "The number of times the method was called and ultimately failed after retrying");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), RETRY_RETRIES_TOTAL), "The total number of times the method was retried");
    }

    static void registerTimeoutMetrics(Method method) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        FaultToleranceMetrics.registerHistogram(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), TIMEOUT_EXECUTION_DURATION), "Histogram of execution times for the method");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), TIMEOUT_CALLS_TIMED_OUT_TOTAL), "The number of times the method timed out");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), TIMEOUT_CALLS_NOT_TIMED_OUT_TOTAL), "The number of times the method completed without timing out");
    }

    static void registerCircuitBreakerMetrics(Method method) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), BREAKER_CALLS_SUCCEEDED_TOTAL), "Number of calls allowed to run by the circuit breaker that returned successfully");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), BREAKER_CALLS_FAILED_TOTAL), "Number of calls allowed to run by the circuit breaker that then failed");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), BREAKER_CALLS_PREVENTED_TOTAL), "Number of calls prevented from running by an open circuit breaker");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), BREAKER_OPENED_TOTAL), "Number of times the circuit breaker has moved from closed state to open state");
    }

    static void registerFallbackMetrics(Method method) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), FALLBACK_CALLS_TOTAL), "Number of times the fallback handler or method was called");
    }

    static void registerBulkheadMetrics(Method method) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), BULKHEAD_CALLS_ACCEPTED_TOTAL), "Number of calls accepted by the bulkhead");
        FaultToleranceMetrics.registerCounter(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), BULKHEAD_CALLS_REJECTED_TOTAL), "Number of calls rejected by the bulkhead");
        FaultToleranceMetrics.registerHistogram(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), BULKHEAD_EXECUTION_DURATION), "Histogram of method execution times. This does not include any time spent waiting in the bulkhead queue.");
    }

    private static Counter registerCounter(String name, String description) {
        return FaultToleranceMetrics.getMetricRegistry().counter(FaultToleranceMetrics.newMetadata(name, name, description, MetricType.COUNTER, "none", true));
    }

    static Histogram registerHistogram(String name, String description) {
        return FaultToleranceMetrics.getMetricRegistry().histogram(FaultToleranceMetrics.newMetadata(name, name, description, MetricType.HISTOGRAM, "nanoseconds", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Gauge<T> registerGauge(Method method, String metricName, String description, Gauge<T> gauge) {
        LOCK.lock();
        try {
            MetricID metricID = FaultToleranceMetrics.newMetricID(String.format(METRIC_NAME_TEMPLATE, method.getDeclaringClass().getName(), method.getName(), metricName));
            Gauge existing = (Gauge)FaultToleranceMetrics.getMetricRegistry().getGauges().get(metricID);
            if (existing == null) {
                FaultToleranceMetrics.getMetricRegistry().register(FaultToleranceMetrics.newMetadata(metricID.getName(), metricID.getName(), description, MetricType.GAUGE, "nanoseconds", true), gauge);
            }
            Gauge gauge2 = existing;
            return gauge2;
        }
        finally {
            LOCK.unlock();
        }
    }

    private static MetricID newMetricID(String name) {
        return new MetricID(name);
    }

    private static Metadata newMetadata(String name, String displayName, String description, MetricType metricType, String metricUnits, boolean isReusable) {
        return Metadata.builder().withName(name).withDisplayName(displayName).withDescription(description).withType(metricType).withUnit(metricUnits).reusable(isReusable).build();
    }
}

