/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.microprofile.faulttolerance.AsynchronousAntn;
import io.helidon.microprofile.faulttolerance.BulkheadAntn;
import io.helidon.microprofile.faulttolerance.CircuitBreakerAntn;
import io.helidon.microprofile.faulttolerance.CommandInterceptor;
import io.helidon.microprofile.faulttolerance.FallbackAntn;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.LiteralCommandBinding;
import io.helidon.microprofile.faulttolerance.MethodAntn;
import io.helidon.microprofile.faulttolerance.RetryAntn;
import io.helidon.microprofile.faulttolerance.TimeoutAntn;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessSyntheticBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.glassfish.jersey.process.internal.RequestScope;

public class FaultToleranceExtension
implements Extension {
    static final String MP_FT_NON_FALLBACK_ENABLED = "MP_Fault_Tolerance_NonFallback_Enabled";
    static final String MP_FT_METRICS_ENABLED = "MP_Fault_Tolerance_Metrics_Enabled";
    static final String MP_FT_INTERCEPTOR_PRIORITY = "mp.fault.tolerance.interceptor.priority";
    private static boolean isFaultToleranceEnabled = true;
    private static boolean isFaultToleranceMetricsEnabled = true;
    private Set<AnnotatedMethod<?>> registeredMethods;
    private ThreadPoolSupplier threadPoolSupplier;
    private ScheduledThreadPoolSupplier scheduledThreadPoolSupplier;

    static boolean isFaultToleranceEnabled() {
        return isFaultToleranceEnabled;
    }

    static boolean isFaultToleranceMetricsEnabled() {
        return isFaultToleranceMetricsEnabled;
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery discovery, BeanManager bm) {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        isFaultToleranceEnabled = config.getOptionalValue(MP_FT_NON_FALLBACK_ENABLED, Boolean.class).orElse(true);
        isFaultToleranceMetricsEnabled = config.getOptionalValue(MP_FT_METRICS_ENABLED, Boolean.class).orElse(true);
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Retry.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(CircuitBreaker.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Timeout.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Asynchronous.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Bulkhead.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Fallback.class), LiteralCommandBinding.getInstance()));
        discovery.addAnnotatedType(bm.createAnnotatedType(CommandInterceptor.class), CommandInterceptor.class.getName());
        discovery.addAnnotatedType(bm.createAnnotatedType(JerseyRequestScopeAsCdiBean.class), JerseyRequestScopeAsCdiBean.class.getName());
    }

    void updatePriorityMaybe(@Observes ProcessAnnotatedType<CommandInterceptor> event) {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        Optional priority = config.getOptionalValue(MP_FT_INTERCEPTOR_PRIORITY, Integer.class);
        priority.ifPresent(v -> event.configureAnnotatedType().remove(a -> a instanceof Priority).add((Annotation)((Object)new LiteralPriority((int)v))));
    }

    void registerFaultToleranceMethods(BeanManager bm, @Observes ProcessSyntheticBean<?> event) {
        this.registerFaultToleranceMethods(bm, bm.createAnnotatedType(event.getBean().getBeanClass()));
    }

    void registerFaultToleranceMethods(BeanManager bm, @Observes ProcessManagedBean<?> event) {
        this.registerFaultToleranceMethods(bm, event.getAnnotatedBeanClass());
    }

    private void registerFaultToleranceMethods(BeanManager bm, AnnotatedType<?> type) {
        for (AnnotatedMethod method : type.getMethods()) {
            if (!FaultToleranceExtension.isFaultToleranceMethod(method, bm)) continue;
            this.getRegisteredMethods().add(method);
        }
    }

    void registerMetricsAndInitExecutors(BeanManager bm, @Observes @Priority(value=1015) @Initialized(value=ApplicationScoped.class) Object event) {
        if (FaultToleranceMetrics.enabled()) {
            this.getRegisteredMethods().forEach(annotatedMethod -> {
                FaultToleranceMetrics.registerMetrics(annotatedMethod.getJavaMember());
                if (MethodAntn.isAnnotationPresent(annotatedMethod, Retry.class, bm)) {
                    FaultToleranceMetrics.registerRetryMetrics(annotatedMethod.getJavaMember());
                    new RetryAntn((AnnotatedMethod<?>)annotatedMethod).validate();
                }
                if (MethodAntn.isAnnotationPresent(annotatedMethod, CircuitBreaker.class, bm)) {
                    FaultToleranceMetrics.registerCircuitBreakerMetrics(annotatedMethod.getJavaMember());
                    new CircuitBreakerAntn((AnnotatedMethod<?>)annotatedMethod).validate();
                }
                if (MethodAntn.isAnnotationPresent(annotatedMethod, Timeout.class, bm)) {
                    FaultToleranceMetrics.registerTimeoutMetrics(annotatedMethod.getJavaMember());
                    new TimeoutAntn((AnnotatedMethod<?>)annotatedMethod).validate();
                }
                if (MethodAntn.isAnnotationPresent(annotatedMethod, Bulkhead.class, bm)) {
                    FaultToleranceMetrics.registerBulkheadMetrics(annotatedMethod.getJavaMember());
                    new BulkheadAntn((AnnotatedMethod<?>)annotatedMethod).validate();
                }
                if (MethodAntn.isAnnotationPresent(annotatedMethod, Fallback.class, bm)) {
                    FaultToleranceMetrics.registerFallbackMetrics(annotatedMethod.getJavaMember());
                    new FallbackAntn((AnnotatedMethod<?>)annotatedMethod).validate();
                }
                if (MethodAntn.isAnnotationPresent(annotatedMethod, Asynchronous.class, bm)) {
                    new AsynchronousAntn((AnnotatedMethod<?>)annotatedMethod).validate();
                }
            });
        }
    }

    void createFaultToleranceExecutors(@Observes AfterDeploymentValidation event) {
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig());
        this.scheduledThreadPoolSupplier = ScheduledThreadPoolSupplier.builder().threadNamePrefix("ft-mp-schedule-").corePoolSize(16).config(config.get("scheduled-executor")).build();
        FaultTolerance.scheduledExecutor((Supplier)this.scheduledThreadPoolSupplier);
        this.threadPoolSupplier = ThreadPoolSupplier.builder().threadNamePrefix("ft-mp-").corePoolSize(16).config(config.get("executor")).build();
        FaultTolerance.executor((Supplier)this.threadPoolSupplier);
    }

    private Set<AnnotatedMethod<?>> getRegisteredMethods() {
        if (this.registeredMethods == null) {
            this.registeredMethods = new CopyOnWriteArraySet();
        }
        return this.registeredMethods;
    }

    static Class<?> getRealClass(Object object) {
        Class<?> result = object.getClass();
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }

    static boolean isFaultToleranceMethod(AnnotatedMethod<?> annotatedMethod, BeanManager bm) {
        return MethodAntn.isAnnotationPresent(annotatedMethod, Retry.class, bm) || MethodAntn.isAnnotationPresent(annotatedMethod, CircuitBreaker.class, bm) || MethodAntn.isAnnotationPresent(annotatedMethod, Bulkhead.class, bm) || MethodAntn.isAnnotationPresent(annotatedMethod, Timeout.class, bm) || MethodAntn.isAnnotationPresent(annotatedMethod, Asynchronous.class, bm) || MethodAntn.isAnnotationPresent(annotatedMethod, Fallback.class, bm);
    }

    public ThreadPoolSupplier threadPoolSupplier() {
        return this.threadPoolSupplier;
    }

    public ScheduledThreadPoolSupplier scheduledThreadPoolSupplier() {
        return this.scheduledThreadPoolSupplier;
    }

    public static class AnnotatedTypeWrapper<T>
    implements AnnotatedType<T> {
        private final AnnotatedType<T> delegate;
        private final Set<Annotation> annotationSet;

        public AnnotatedTypeWrapper(AnnotatedType<T> delegate, Annotation ... annotations) {
            this.delegate = delegate;
            this.annotationSet = new HashSet<Annotation>(Arrays.asList(annotations));
            for (Annotation da : delegate.getAnnotations()) {
                boolean overridden = false;
                for (Annotation na : this.annotationSet) {
                    if (!da.annotationType().isAssignableFrom(na.annotationType())) continue;
                    overridden = true;
                    break;
                }
                if (overridden) continue;
                this.annotationSet.add(da);
            }
        }

        public Class<T> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public Set<AnnotatedConstructor<T>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super T>> getMethods() {
            return this.delegate.getMethods();
        }

        public Set<AnnotatedField<? super T>> getFields() {
            return this.delegate.getFields();
        }

        public <R extends Annotation> R getAnnotation(Class<R> annotationType) {
            Optional<Annotation> optional = this.annotationSet.stream().filter(a -> annotationType.isAssignableFrom(a.annotationType())).findFirst();
            return (R)((Annotation)optional.orElse(null));
        }

        public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
            return this.annotationSet.stream().filter(a -> annotationType.isAssignableFrom(a.annotationType())).collect(Collectors.toSet());
        }

        public Set<Annotation> getAnnotations() {
            return this.annotationSet;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            Annotation annotation = this.getAnnotation(annotationType);
            return annotation != null;
        }
    }

    private static class JerseyRequestScopeAsCdiBean {
        @Inject
        private RequestScope requestScope;

        private JerseyRequestScopeAsCdiBean() {
        }
    }

    private static class LiteralPriority
    extends AnnotationLiteral<Priority>
    implements Priority {
        private final int value;

        LiteralPriority(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

