/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.MethodAntn;
import java.time.temporal.ChronoUnit;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

class CircuitBreakerAntn
extends MethodAntn
implements CircuitBreaker {
    CircuitBreakerAntn(AnnotatedMethod<?> annotatedMethod) {
        super(annotatedMethod);
    }

    @Override
    public void validate() {
        if (this.delay() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker annotation, delay must be >= 0");
        }
        if (this.requestVolumeThreshold() < 1) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker annotation, requestVolumeThreshold must be >= 1");
        }
        double failureRatio = this.failureRatio();
        if (failureRatio < 0.0 || failureRatio > 1.0) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker annotation, failureRatio must be >= 0 and <= 1");
        }
        if (this.successThreshold() < 1) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker annotation, successThreshold must be >= 1");
        }
    }

    public long delay() {
        MethodAntn.LookupResult<CircuitBreaker> lookupResult = this.lookupAnnotation(CircuitBreaker.class);
        String override = this.getParamOverride("delay", lookupResult.getType());
        return override != null ? Long.parseLong(override) : lookupResult.getAnnotation().delay();
    }

    public ChronoUnit delayUnit() {
        MethodAntn.LookupResult<CircuitBreaker> lookupResult = this.lookupAnnotation(CircuitBreaker.class);
        String override = this.getParamOverride("delayUnit", lookupResult.getType());
        return override != null ? ChronoUnit.valueOf(override) : lookupResult.getAnnotation().delayUnit();
    }

    public int requestVolumeThreshold() {
        MethodAntn.LookupResult<CircuitBreaker> lookupResult = this.lookupAnnotation(CircuitBreaker.class);
        String override = this.getParamOverride("requestVolumeThreshold", lookupResult.getType());
        return override != null ? Integer.parseInt(override) : lookupResult.getAnnotation().requestVolumeThreshold();
    }

    public double failureRatio() {
        MethodAntn.LookupResult<CircuitBreaker> lookupResult = this.lookupAnnotation(CircuitBreaker.class);
        String override = this.getParamOverride("failureRatio", lookupResult.getType());
        return override != null ? Double.parseDouble(override) : lookupResult.getAnnotation().failureRatio();
    }

    public int successThreshold() {
        MethodAntn.LookupResult<CircuitBreaker> lookupResult = this.lookupAnnotation(CircuitBreaker.class);
        String override = this.getParamOverride("successThreshold", lookupResult.getType());
        return override != null ? Integer.parseInt(override) : lookupResult.getAnnotation().successThreshold();
    }

    public Class<? extends Throwable>[] failOn() {
        MethodAntn.LookupResult<CircuitBreaker> lookupResult = this.lookupAnnotation(CircuitBreaker.class);
        String override = this.getParamOverride("failOn", lookupResult.getType());
        return override != null ? CircuitBreakerAntn.parseThrowableArray(override) : lookupResult.getAnnotation().failOn();
    }

    public Class<? extends Throwable>[] skipOn() {
        MethodAntn.LookupResult<CircuitBreaker> lookupResult = this.lookupAnnotation(CircuitBreaker.class);
        String override = this.getParamOverride("skipOn", lookupResult.getType());
        return override != null ? CircuitBreakerAntn.parseThrowableArray(override) : lookupResult.getAnnotation().skipOn();
    }
}

