/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.MethodAntn;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

class BulkheadAntn
extends MethodAntn
implements Bulkhead {
    BulkheadAntn(AnnotatedMethod<?> annotatedMethod) {
        super(annotatedMethod);
    }

    @Override
    public void validate() {
        if (this.value() <= 0) {
            throw new FaultToleranceDefinitionException("Invalid @Bulkhead annotation, value must be > 0");
        }
        if (this.waitingTaskQueue() <= 0) {
            throw new FaultToleranceDefinitionException("Invalid @Bulkhead annotation, waitingTaskQueue must be > 0");
        }
    }

    public int value() {
        MethodAntn.LookupResult<Bulkhead> lookupResult = this.lookupAnnotation(Bulkhead.class);
        String override = this.getParamOverride("value", lookupResult.getType());
        return override != null ? Integer.parseInt(override) : lookupResult.getAnnotation().value();
    }

    public int waitingTaskQueue() {
        MethodAntn.LookupResult<Bulkhead> lookupResult = this.lookupAnnotation(Bulkhead.class);
        String override = this.getParamOverride("waitingTaskQueue", lookupResult.getType());
        return override != null ? Integer.parseInt(override) : lookupResult.getAnnotation().waitingTaskQueue();
    }
}

