/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.FtSupplier;
import java.lang.annotation.Annotation;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.process.internal.RequestContext;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.weld.se.WeldRequestScope;

class RequestScopeHelper {
    private State state = State.CLEARED;
    private RequestContextController requestController;
    private RequestScope requestScope;
    private RequestContext requestContext;
    private InjectionManager injectionManager;

    RequestScopeHelper() {
    }

    void saveScope() {
        if (this.state == State.STORED) {
            throw new IllegalStateException("Request scope state already stored");
        }
        Instance rcc = CDI.current().select(RequestContextController.class, new Annotation[0]);
        if (rcc.isResolvable()) {
            this.requestController = (RequestContextController)rcc.get();
        }
        this.injectionManager = (InjectionManager)WeldRequestScope.actualInjectorManager.get();
        try {
            this.requestScope = (RequestScope)CDI.current().select(RequestScope.class, new Annotation[0]).get();
            this.requestContext = this.requestScope.referenceCurrent();
        }
        catch (Exception exception) {
        }
        finally {
            this.state = State.STORED;
        }
    }

    FtSupplier<Object> wrapInScope(FtSupplier<Object> supplier) {
        if (this.state != State.STORED) {
            throw new IllegalStateException("Request scope state never stored");
        }
        if (this.requestScope != null && this.requestContext != null) {
            return () -> this.requestScope.runInScope(this.requestContext, () -> {
                InjectionManager old = (InjectionManager)WeldRequestScope.actualInjectorManager.get();
                try {
                    this.requestController.activate();
                    WeldRequestScope.actualInjectorManager.set(this.injectionManager);
                    Object t = supplier.get();
                    return t;
                }
                catch (Throwable t) {
                    throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
                }
                finally {
                    this.requestController.deactivate();
                    WeldRequestScope.actualInjectorManager.set(old);
                }
            });
        }
        if (this.requestController != null) {
            return () -> {
                try {
                    this.requestController.activate();
                    Object t = supplier.get();
                    return t;
                }
                finally {
                    this.requestController.deactivate();
                }
            };
        }
        return supplier;
    }

    void clearScope() {
        if (this.requestContext != null) {
            this.requestContext.release();
            this.requestContext = null;
        }
        this.requestScope = null;
        this.requestController = null;
        this.injectionManager = null;
        this.state = State.CLEARED;
    }

    static enum State {
        CLEARED,
        STORED;

    }
}

