/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.BulkheadAntn;
import io.helidon.microprofile.faulttolerance.CircuitBreakerAntn;
import io.helidon.microprofile.faulttolerance.FallbackAntn;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import io.helidon.microprofile.faulttolerance.FaultToleranceParameter;
import io.helidon.microprofile.faulttolerance.MethodAntn;
import io.helidon.microprofile.faulttolerance.RetryAntn;
import io.helidon.microprofile.faulttolerance.TimeoutAntn;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

class MethodIntrospector {
    private final Method method;
    private final Class<?> beanClass;
    private final Retry retry;
    private final Fallback fallback;
    private final CircuitBreaker circuitBreaker;
    private final Timeout timeout;
    private final Bulkhead bulkhead;

    MethodIntrospector(Class<?> beanClass, Method method) {
        this.beanClass = beanClass;
        this.method = method;
        this.retry = this.isAnnotationEnabled(Retry.class) ? new RetryAntn(beanClass, method) : null;
        this.circuitBreaker = this.isAnnotationEnabled(CircuitBreaker.class) ? new CircuitBreakerAntn(beanClass, method) : null;
        this.timeout = this.isAnnotationEnabled(Timeout.class) ? new TimeoutAntn(beanClass, method) : null;
        this.bulkhead = this.isAnnotationEnabled(Bulkhead.class) ? new BulkheadAntn(beanClass, method) : null;
        this.fallback = this.isAnnotationEnabled(Fallback.class) ? new FallbackAntn(beanClass, method) : null;
    }

    Method method() {
        return this.method;
    }

    boolean isReturnType(Class<?> clazz) {
        return clazz.isAssignableFrom(this.method.getReturnType());
    }

    boolean hasRetry() {
        return this.retry != null;
    }

    Retry getRetry() {
        return this.retry;
    }

    boolean hasFallback() {
        return this.fallback != null;
    }

    Fallback getFallback() {
        return this.fallback;
    }

    boolean isAsynchronous() {
        return this.isAnnotationEnabled(Asynchronous.class);
    }

    boolean hasCircuitBreaker() {
        return this.circuitBreaker != null;
    }

    CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    boolean hasTimeout() {
        return this.timeout != null;
    }

    Timeout getTimeout() {
        return this.timeout;
    }

    boolean hasBulkhead() {
        return this.bulkhead != null;
    }

    Bulkhead getBulkhead() {
        return this.bulkhead;
    }

    private boolean isAnnotationEnabled(Class<? extends Annotation> clazz) {
        MethodAntn.LookupResult<? extends Annotation> lookupResult = MethodAntn.lookupAnnotation(this.beanClass, this.method, clazz);
        if (lookupResult == null) {
            return false;
        }
        String annotationType = clazz.getSimpleName();
        String value = FaultToleranceParameter.getParameter(this.method.getDeclaringClass().getName(), this.method.getName(), annotationType, "enabled");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        value = FaultToleranceParameter.getParameter(this.method.getDeclaringClass().getName(), annotationType, "enabled");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        value = FaultToleranceParameter.getParameter(annotationType, "enabled");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return clazz == Fallback.class || FaultToleranceExtension.isFaultToleranceEnabled();
    }
}

