/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.Bulkhead;
import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.Fallback;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandlerTyped;
import io.helidon.faulttolerance.Retry;
import io.helidon.faulttolerance.Timeout;
import io.helidon.microprofile.faulttolerance.CommandFallback;
import io.helidon.microprofile.faulttolerance.FaultToleranceExtension;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.FtSupplier;
import io.helidon.microprofile.faulttolerance.InvokerAsyncException;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import io.helidon.microprofile.faulttolerance.ThrowableMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.metrics.Counter;
import org.glassfish.jersey.process.internal.RequestContext;
import org.glassfish.jersey.process.internal.RequestScope;

class MethodInvoker
implements FtSupplier<Object> {
    private static final Logger LOGGER = Logger.getLogger(MethodInvoker.class.getName());
    private final Method method;
    private final InvocationContext context;
    private final MethodIntrospector introspector;
    private static final ConcurrentHashMap<MethodStateKey, MethodState> METHOD_STATES = new ConcurrentHashMap();
    private long handlerStartNanos;
    private long invocationStartNanos;
    private final Context helidonContext;
    private RequestScope requestScope;
    private RequestContext requestContext;
    private RequestContextController requestController;
    private final AtomicBoolean mayInterruptIfRunning = new AtomicBoolean(false);
    private Thread asyncInterruptThread;
    private final MethodState methodState;

    MethodInvoker(InvocationContext context, MethodIntrospector introspector) {
        this.context = context;
        this.introspector = introspector;
        this.method = context.getMethod();
        this.helidonContext = Contexts.context().orElseGet(Context::create);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Objects.requireNonNull(ccl);
        MethodStateKey methodStateKey = new MethodStateKey(ccl, context.getTarget().getClass(), this.method);
        this.methodState = METHOD_STATES.computeIfAbsent(methodStateKey, key -> {
            MethodState methodState = new MethodState();
            methodState.lastBreakerState = CircuitBreaker.State.CLOSED;
            if (introspector.hasCircuitBreaker()) {
                methodState.breakerTimerOpen = 0L;
                methodState.breakerTimerClosed = 0L;
                methodState.breakerTimerHalfOpen = 0L;
                methodState.startNanos = System.nanoTime();
            }
            methodState.handler = this.createMethodHandler(methodState);
            return methodState;
        });
        try {
            this.requestController = (RequestContextController)CDI.current().select(RequestContextController.class, new Annotation[0]).get();
            this.requestScope = (RequestScope)CDI.current().select(RequestScope.class, new Annotation[0]).get();
            this.requestContext = this.requestScope.current();
        }
        catch (Exception e) {
            this.requestScope = null;
            LOGGER.fine(() -> "Request context not active for method " + this.method + " on thread " + Thread.currentThread().getName());
        }
        if (FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            if (introspector.hasCircuitBreaker()) {
                FaultToleranceMetrics.registerGauge(this.method, "circuitbreaker.open.total", "Amount of time the circuit breaker has spent in open state", () -> this.methodState.breakerTimerOpen);
                FaultToleranceMetrics.registerGauge(this.method, "circuitbreaker.halfOpen.total", "Amount of time the circuit breaker has spent in half-open state", () -> this.methodState.breakerTimerHalfOpen);
                FaultToleranceMetrics.registerGauge(this.method, "circuitbreaker.closed.total", "Amount of time the circuit breaker has spent in closed state", () -> this.methodState.breakerTimerClosed);
            }
            if (introspector.hasBulkhead()) {
                FaultToleranceMetrics.registerGauge(this.method, "bulkhead.concurrentExecutions", "Number of currently running executions", () -> this.methodState.bulkhead.stats().concurrentExecutions());
                if (introspector.isAsynchronous()) {
                    FaultToleranceMetrics.registerGauge(this.method, "bulkhead.waitingQueue.population", "Number of executions currently waiting in the queue", () -> this.methodState.bulkhead.stats().waitingQueueSize());
                    FaultToleranceMetrics.registerHistogram(String.format("ft.%s.%s.%s", this.method.getDeclaringClass().getName(), this.method.getName(), "bulkhead.waiting.duration"), "Histogram of the time executions spend waiting in the queue.");
                }
            }
        }
    }

    public String toString() {
        String s = super.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(s.substring(s.lastIndexOf(46) + 1)).append(" ").append(this.method.getDeclaringClass().getSimpleName()).append(".").append(this.method.getName()).append("()");
        return sb.toString();
    }

    static void clearMethodStatesMap() {
        METHOD_STATES.clear();
    }

    @Override
    public Object get() throws Throwable {
        Supplier<Single> supplier = () -> {
            try {
                return (Single)Contexts.runInContextWithThrow((Context)this.helidonContext, () -> this.methodState.handler.invoke(this.toCompletionStageSupplier(() -> ((InvocationContext)this.context).proceed())));
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
        };
        this.updateMetricsBefore();
        if (this.introspector.isAsynchronous()) {
            Single single = supplier.get();
            CompletableFuture asyncFuture = single.toStage(true).toCompletableFuture();
            InvokerCompletableFuture resultFuture = new InvokerCompletableFuture();
            asyncFuture.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof CancellationException) {
                        single.cancel();
                        return;
                    }
                    Throwable cause = throwable instanceof ExecutionException ? ThrowableMapper.map(throwable.getCause()) : ThrowableMapper.map(throwable);
                    this.updateMetricsAfter(cause);
                    resultFuture.completeExceptionally(cause);
                } else {
                    this.updateMetricsAfter(null);
                    resultFuture.complete(result);
                }
            });
            resultFuture.whenComplete((result, throwable) -> {
                if (throwable instanceof CancellationException) {
                    asyncFuture.cancel(true);
                }
            });
            return resultFuture;
        }
        Object result2 = null;
        Throwable cause = null;
        try {
            Single single = supplier.get();
            CompletableFuture future = single.toStage(true).toCompletableFuture();
            result2 = future.get();
        }
        catch (ExecutionException e) {
            cause = ThrowableMapper.map(e.getCause());
        }
        catch (Throwable t) {
            cause = ThrowableMapper.map(t);
        }
        this.updateMetricsAfter(cause);
        if (cause != null) {
            throw cause;
        }
        return result2;
    }

    private FtSupplier<Object> requestContextSupplier(FtSupplier<Object> supplier) {
        FtSupplier<Object> wrappedSupplier = this.requestScope != null ? () -> this.requestScope.runInScope(this.requestContext, () -> {
            try {
                this.requestController.activate();
                Object t = supplier.get();
                return t;
            }
            catch (Throwable t) {
                throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
            }
            finally {
                this.requestController.deactivate();
            }
        }) : (this.requestController != null ? () -> {
            try {
                this.requestController.activate();
                Object t = supplier.get();
                return t;
            }
            finally {
                this.requestController.deactivate();
            }
        } : supplier);
        return wrappedSupplier;
    }

    private FtHandlerTyped<Object> createMethodHandler(MethodState methodState) {
        FaultTolerance.TypedBuilder builder = FaultTolerance.typedBuilder();
        if (this.introspector.hasBulkhead()) {
            methodState.bulkhead = Bulkhead.builder().limit(this.introspector.getBulkhead().value()).queueLength(this.introspector.isAsynchronous() ? this.introspector.getBulkhead().waitingTaskQueue() : 0).build();
            builder.addBulkhead(methodState.bulkhead);
        }
        if (this.introspector.hasTimeout()) {
            Timeout timeout = Timeout.builder().timeout(Duration.of(this.introspector.getTimeout().value(), this.introspector.getTimeout().unit())).currentThread(!this.introspector.isAsynchronous()).build();
            builder.addTimeout(timeout);
        }
        if (this.introspector.hasCircuitBreaker()) {
            methodState.breaker = CircuitBreaker.builder().delay(Duration.of(this.introspector.getCircuitBreaker().delay(), this.introspector.getCircuitBreaker().delayUnit())).successThreshold(this.introspector.getCircuitBreaker().successThreshold()).errorRatio((int)(this.introspector.getCircuitBreaker().failureRatio() * 100.0)).volume(this.introspector.getCircuitBreaker().requestVolumeThreshold()).applyOn((Class[])ThrowableMapper.mapTypes(this.introspector.getCircuitBreaker().failOn())).skipOn((Class[])ThrowableMapper.mapTypes(this.introspector.getCircuitBreaker().skipOn())).build();
            builder.addBreaker(methodState.breaker);
        }
        if (this.introspector.hasRetry()) {
            Retry retry = Retry.builder().retryPolicy((Retry.RetryPolicy)Retry.JitterRetryPolicy.builder().calls(this.introspector.getRetry().maxRetries() + 1).delay(Duration.of(this.introspector.getRetry().delay(), this.introspector.getRetry().delayUnit())).jitter(Duration.of(this.introspector.getRetry().jitter(), this.introspector.getRetry().jitterDelayUnit())).build()).overallTimeout(Duration.of(this.introspector.getRetry().maxDuration(), this.introspector.getRetry().durationUnit())).applyOn((Class[])ThrowableMapper.mapTypes(this.introspector.getRetry().retryOn())).skipOn((Class[])ThrowableMapper.mapTypes(this.introspector.getRetry().abortOn())).build();
            builder.addRetry(retry);
            methodState.retry = retry;
        }
        if (this.introspector.hasFallback()) {
            Fallback fallback = Fallback.builder().fallback(throwable -> {
                CommandFallback cfb = new CommandFallback(this.context, this.introspector, (Throwable)throwable);
                return this.toCompletionStageSupplier(cfb::execute).get();
            }).applyOn((Class[])ThrowableMapper.mapTypes(this.introspector.getFallback().applyOn())).skipOn((Class[])ThrowableMapper.mapTypes(this.introspector.getFallback().skipOn())).build();
            builder.addFallback(fallback);
        }
        return builder.build();
    }

    Supplier<? extends CompletionStage<Object>> toCompletionStageSupplier(FtSupplier<Object> supplier) {
        return () -> {
            this.invocationStartNanos = System.nanoTime();
            CompletableFuture resultFuture = new CompletableFuture();
            if (this.introspector.isAsynchronous()) {
                FtSupplier<Object> wrappedSupplier = this.requestContextSupplier(supplier);
                ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                Single single = Async.create().invoke(() -> {
                    try {
                        Thread.currentThread().setContextClassLoader(ccl);
                        this.asyncInterruptThread = Thread.currentThread();
                        return wrappedSupplier.get();
                    }
                    catch (Throwable t) {
                        return new InvokerAsyncException(t);
                    }
                });
                resultFuture.whenComplete((result, throwable) -> {
                    if (throwable instanceof CancellationException) {
                        single.cancel();
                        if (this.mayInterruptIfRunning.get() && this.asyncInterruptThread != null) {
                            this.asyncInterruptThread.interrupt();
                            this.asyncInterruptThread = null;
                        }
                    }
                });
                single.thenAccept(result -> {
                    block5: {
                        try {
                            if (result instanceof InvokerAsyncException) {
                                resultFuture.completeExceptionally(((Exception)result).getCause());
                                break block5;
                            }
                            if (this.method.getReturnType() == Future.class) {
                                resultFuture.complete(result);
                                break block5;
                            }
                            if (result instanceof CompletionStage) {
                                CompletionStage cs = (CompletionStage)result;
                                cs.whenComplete((o, t) -> {
                                    if (t != null) {
                                        resultFuture.completeExceptionally((Throwable)t);
                                    } else {
                                        resultFuture.complete(o);
                                    }
                                });
                                break block5;
                            }
                            throw new InternalError("Return type validation failed for method " + this.method);
                        }
                        catch (Throwable t2) {
                            resultFuture.completeExceptionally(t2);
                        }
                    }
                });
            } else {
                try {
                    resultFuture.complete(supplier.get());
                    return resultFuture;
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            }
            return resultFuture;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetricsBefore() {
        this.handlerStartNanos = System.nanoTime();
        if (this.introspector.hasCircuitBreaker()) {
            Method method = this.method;
            synchronized (method) {
                this.methodState.lastBreakerState = this.methodState.breaker.state();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMetricsAfter(Throwable cause) {
        if (!FaultToleranceExtension.isFaultToleranceMetricsEnabled()) {
            return;
        }
        Method method = this.method;
        synchronized (method) {
            long executionTime = System.nanoTime() - this.handlerStartNanos;
            if (this.introspector.hasRetry()) {
                long newValue = this.methodState.retry.retryCounter();
                if (MethodInvoker.updateCounter(this.method, "retry.retries.total", newValue)) {
                    if (cause == null) {
                        FaultToleranceMetrics.getCounter(this.method, "retry.callsSucceededRetried.total").inc();
                    }
                } else {
                    FaultToleranceMetrics.getCounter(this.method, "retry.callsSucceededNotRetried.total").inc();
                }
                if (cause != null) {
                    FaultToleranceMetrics.getCounter(this.method, "retry.callsFailed.total").inc();
                }
            }
            if (this.introspector.hasTimeout()) {
                FaultToleranceMetrics.getHistogram(this.method, "timeout.executionDuration").update(executionTime);
                FaultToleranceMetrics.getCounter(this.method, cause instanceof org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException ? "timeout.callsTimedOut.total" : "timeout.callsNotTimedOut.total").inc();
            }
            if (this.introspector.hasCircuitBreaker()) {
                Objects.requireNonNull(this.methodState.breaker);
                if (this.methodState.lastBreakerState == CircuitBreaker.State.OPEN) {
                    FaultToleranceMetrics.getCounter(this.method, "circuitbreaker.callsPrevented.total").inc();
                } else if (this.methodState.breaker.state() == CircuitBreaker.State.OPEN) {
                    FaultToleranceMetrics.getCounter(this.method, "circuitbreaker.opened.total").inc();
                }
                if (cause == null) {
                    FaultToleranceMetrics.getCounter(this.method, "circuitbreaker.callsSucceeded.total").inc();
                } else if (!(cause instanceof CircuitBreakerOpenException)) {
                    Class[] failOn;
                    boolean failure = false;
                    for (Class c : failOn = this.introspector.getCircuitBreaker().failOn()) {
                        if (!c.isAssignableFrom(cause.getClass())) continue;
                        failure = true;
                        break;
                    }
                    FaultToleranceMetrics.getCounter(this.method, failure ? "circuitbreaker.callsFailed.total" : "circuitbreaker.callsSucceeded.total").inc();
                }
                switch (this.methodState.lastBreakerState) {
                    case OPEN: {
                        this.methodState.breakerTimerOpen += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    case CLOSED: {
                        this.methodState.breakerTimerClosed += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    case HALF_OPEN: {
                        this.methodState.breakerTimerHalfOpen += System.nanoTime() - this.methodState.startNanos;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown breaker state " + this.methodState.lastBreakerState);
                    }
                }
                this.methodState.lastBreakerState = this.methodState.breaker.state();
                this.methodState.startNanos = System.nanoTime();
            }
            if (this.introspector.hasBulkhead()) {
                Objects.requireNonNull(this.methodState.bulkhead);
                Bulkhead.Stats stats = this.methodState.bulkhead.stats();
                MethodInvoker.updateCounter(this.method, "bulkhead.callsAccepted.total", stats.callsAccepted());
                MethodInvoker.updateCounter(this.method, "bulkhead.callsRejected.total", stats.callsRejected());
                if (!(cause instanceof BulkheadException)) {
                    long waitingTime = this.invocationStartNanos - this.handlerStartNanos;
                    FaultToleranceMetrics.getHistogram(this.method, "bulkhead.executionDuration").update(executionTime - waitingTime);
                    if (this.introspector.isAsynchronous()) {
                        FaultToleranceMetrics.getHistogram(this.method, "bulkhead.waiting.duration").update(waitingTime);
                    }
                }
            }
            FaultToleranceMetrics.getCounter(this.method, "invocations.total").inc();
            if (cause != null) {
                FaultToleranceMetrics.getCounter(this.method, "invocations.failed.total").inc();
            }
        }
    }

    private static boolean updateCounter(Method method, String name, long newValue) {
        Counter counter = FaultToleranceMetrics.getCounter(method, name);
        long oldValue = counter.getCount();
        if (newValue > oldValue) {
            counter.inc(newValue - oldValue);
            return true;
        }
        return false;
    }

    class InvokerCompletableFuture<T>
    extends CompletableFuture<T> {
        InvokerCompletableFuture() {
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            Object value = super.get();
            if (MethodInvoker.this.method.getReturnType() == Future.class) {
                return (T)((Future)value).get();
            }
            return value;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object value = super.get();
            if (MethodInvoker.this.method.getReturnType() == Future.class) {
                return (T)((Future)value).get(timeout, unit);
            }
            return value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            MethodInvoker.this.mayInterruptIfRunning.set(mayInterruptIfRunning);
            return super.cancel(mayInterruptIfRunning);
        }
    }

    private static class MethodStateKey {
        private final ClassLoader classLoader;
        private final Class<?> methodClass;
        private final Method method;

        MethodStateKey(ClassLoader classLoader, Class<?> methodClass, Method method) {
            this.classLoader = classLoader;
            this.methodClass = methodClass;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodStateKey that = (MethodStateKey)o;
            return this.classLoader.equals(that.classLoader) && this.methodClass.equals(that.methodClass) && this.method.equals(that.method);
        }

        public int hashCode() {
            return Objects.hash(this.classLoader, this.methodClass, this.method);
        }
    }

    private static class MethodState {
        private FtHandlerTyped<Object> handler;
        private Retry retry;
        private Bulkhead bulkhead;
        private CircuitBreaker breaker;
        private CircuitBreaker.State lastBreakerState;
        private long breakerTimerOpen;
        private long breakerTimerClosed;
        private long breakerTimerHalfOpen;
        private long startNanos;

        private MethodState() {
        }
    }
}

