/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    public static TimeUnit chronoUnitToTimeUnit(ChronoUnit chronoUnit) {
        switch (Objects.requireNonNull(chronoUnit, "chronoUnit")) {
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("No TimeUnit equivalent for ChronoUnit");
    }

    public static ChronoUnit timeUnitToChronoUnit(TimeUnit timeUnit) {
        switch (Objects.requireNonNull(timeUnit, "chronoUnit")) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("No ChronoUnit equivalent for TimeUnit");
    }

    public static long convertToMillis(long duration, ChronoUnit chronoUnit) {
        TimeUnit timeUnit = TimeUtil.chronoUnitToTimeUnit(chronoUnit);
        return TimeUnit.MILLISECONDS.convert(duration, timeUnit);
    }

    public static long convertToNanos(long duration, ChronoUnit chronoUnit) {
        TimeUnit timeUnit = TimeUtil.chronoUnitToTimeUnit(chronoUnit);
        return TimeUnit.NANOSECONDS.convert(duration, timeUnit);
    }

    private TimeUtil() {
    }
}

