/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import com.netflix.hystrix.exception.HystrixRuntimeException;

public class ExceptionUtil {
    public static Exception toException(Throwable throwable) {
        return throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
    }

    public static WrappedException toWrappedException(Throwable throwable) {
        return throwable instanceof WrappedException ? (WrappedException)throwable : new WrappedException(throwable);
    }

    public static Throwable unwrapHystrix(Throwable throwable) {
        return throwable instanceof HystrixRuntimeException ? throwable.getCause() : throwable;
    }

    private ExceptionUtil() {
    }

    static class WrappedException
    extends RuntimeException {
        WrappedException(Throwable t) {
            super(t);
        }
    }
}

