/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class CommandScheduler
implements Scheduler {
    private static final String THREAD_NAME_PREFIX = "helidon-ft-async-";
    private static CommandScheduler instance;
    private final ScheduledThreadPoolSupplier poolSupplier;

    private CommandScheduler(ScheduledThreadPoolSupplier poolSupplier) {
        this.poolSupplier = poolSupplier;
    }

    public static synchronized CommandScheduler create(int threadPoolSize) {
        if (instance == null) {
            instance = new CommandScheduler(ScheduledThreadPoolSupplier.builder().daemon(true).threadNamePrefix(THREAD_NAME_PREFIX).corePoolSize(threadPoolSize).prestart(false).build());
        }
        return instance;
    }

    ScheduledThreadPoolSupplier poolSupplier() {
        return this.poolSupplier;
    }

    public ScheduledFuture<?> schedule(Callable<?> callable, long delay, TimeUnit unit) {
        return this.poolSupplier.get().schedule(callable, delay, unit);
    }
}

