/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.ExceptionUtil;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.JavaMethodFinder;
import io.helidon.microprofile.faulttolerance.MethodIntrospector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.InvocationContext;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

class CommandFallback {
    private final InvocationContext context;
    private final Throwable throwable;
    private Class<? extends FallbackHandler<?>> handlerClass;
    private Method fallbackMethod;

    CommandFallback(InvocationContext context, MethodIntrospector introspector, ExecutionAttemptedEvent<?> event) {
        this.context = context;
        this.throwable = event.getLastFailure();
        Fallback fallback = introspector.getFallback();
        if (fallback.value() != Fallback.DEFAULT.class) {
            this.handlerClass = fallback.value();
        } else if (!fallback.fallbackMethod().isEmpty()) {
            Object instance = context.getTarget();
            try {
                this.fallbackMethod = JavaMethodFinder.findMethod(instance.getClass(), introspector.getFallback().fallbackMethod(), context.getMethod().getGenericParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e);
            }
        } else {
            this.handlerClass = Fallback.DEFAULT.class;
        }
    }

    public Object execute() throws Exception {
        Object result;
        assert (this.handlerClass != null || this.fallbackMethod != null);
        try {
            if (this.handlerClass != null) {
                FallbackHandler handler = (FallbackHandler)CDI.current().select(this.handlerClass, new Annotation[0]).get();
                result = handler.handle(new ExecutionContext(){

                    public Method getMethod() {
                        return CommandFallback.this.context.getMethod();
                    }

                    public Object[] getParameters() {
                        return CommandFallback.this.context.getParameters();
                    }

                    public Throwable getFailure() {
                        return CommandFallback.this.throwable;
                    }
                });
            } else {
                result = this.fallbackMethod.invoke(this.context.getTarget(), this.context.getParameters());
            }
        }
        catch (Throwable t) {
            this.updateMetrics(t);
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            throw ExceptionUtil.toException(t);
        }
        this.updateMetrics(null);
        return result;
    }

    private void updateMetrics(Throwable throwable) {
        Method method = this.context.getMethod();
        FaultToleranceMetrics.getCounter(method, "fallback.calls.total").inc();
        if (throwable == null) {
            FaultToleranceMetrics.getCounter(method, "invocations.failed.total").inc(-1L);
        }
    }
}

