/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.BulkheadHelper;
import io.helidon.microprofile.faulttolerance.FaultToleranceCommand;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class CommandCompletableFuture<T>
extends CompletableFuture<T> {
    private final CompletableFuture<T> delegate;
    private final Supplier<FaultToleranceCommand> commandSupplier;

    static <U> CommandCompletableFuture<U> create(CompletableFuture<U> delegate, Supplier<FaultToleranceCommand> commandSupplier) {
        return new CommandCompletableFuture<U>(delegate, commandSupplier);
    }

    private CommandCompletableFuture(CompletableFuture<T> delegate, Supplier<FaultToleranceCommand> commandSupplier) {
        this.delegate = delegate;
        this.commandSupplier = commandSupplier;
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.getResult(-1L, null);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getResult(timeout, unit);
    }

    T getResult(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        Object result;
        T t = result = timeout < 0L ? this.delegate.get() : this.delegate.get(timeout, unit);
        if (result instanceof CompletionStage) {
            result = ((CompletionStage)result).toCompletableFuture();
        }
        if (result instanceof Future) {
            Future future = (Future)result;
            return (T)(timeout < 0L ? future.get() : future.get(timeout, unit));
        }
        return result;
    }

    @Override
    public T join() {
        return this.delegate.join();
    }

    @Override
    public T getNow(T valueIfAbsent) {
        return this.delegate.getNow(valueIfAbsent);
    }

    @Override
    public boolean complete(T value) {
        return this.delegate.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.delegate.completeExceptionally(ex);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.delegate.thenApply(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.delegate.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.delegate.thenApplyAsync(fn, executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.delegate.thenAccept((Consumer)action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.delegate.thenAcceptAsync((Consumer)action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.delegate.thenAcceptAsync((Consumer)action, executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.delegate.thenRun(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.delegate.thenRunAsync(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.delegate.thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.delegate.thenCombine(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.delegate.thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.delegate.thenCombineAsync(other, fn, executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.delegate.thenAcceptBoth(other, (BiConsumer)action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.delegate.thenAcceptBothAsync(other, (BiConsumer)action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.delegate.thenAcceptBothAsync(other, (BiConsumer)action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.delegate.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.delegate.runAfterBothAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.delegate.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.delegate.applyToEither((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.delegate.applyToEitherAsync((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.delegate.applyToEitherAsync((CompletionStage)other, fn, executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.delegate.acceptEither((CompletionStage)other, (Consumer)action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.delegate.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.delegate.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.delegate.runAfterEitherAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.delegate.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.delegate.thenCompose(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.delegate.thenComposeAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.delegate.thenComposeAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.delegate.whenComplete(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.delegate.whenCompleteAsync(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.delegate.whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.delegate.handle(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.delegate.handleAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.delegate.handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.delegate.exceptionally(fn);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        FaultToleranceCommand command = this.commandSupplier.get();
        BulkheadHelper bulkheadHelper = command.getBulkheadHelper();
        if (bulkheadHelper != null && !bulkheadHelper.isInvocationRunning(command)) {
            return this.delegate.cancel(true);
        }
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.delegate.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(T value) {
        this.delegate.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.delegate.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.delegate.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return String.format("%s@%h around %s", this.getClass().getName(), this, this.delegate.toString());
    }
}

