/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.microprofile.faulttolerance.BulkheadHelper;
import io.helidon.microprofile.faulttolerance.CommandRetrier;
import io.helidon.microprofile.faulttolerance.FaultToleranceCommand;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class CommandScheduler
implements Scheduler {
    private static final String THREAD_NAME_PREFIX = "helidon-ft-async-";
    private static CommandScheduler instance;
    private final ScheduledThreadPoolSupplier poolSupplier;

    private CommandScheduler(ScheduledThreadPoolSupplier poolSupplier) {
        this.poolSupplier = poolSupplier;
    }

    public static synchronized CommandScheduler create(int threadPoolSize) {
        if (instance == null) {
            instance = new CommandScheduler(ScheduledThreadPoolSupplier.builder().daemon(false).threadNamePrefix(THREAD_NAME_PREFIX).corePoolSize(threadPoolSize).prestart(false).build());
        }
        return instance;
    }

    ScheduledThreadPoolSupplier poolSupplier() {
        return this.poolSupplier;
    }

    public ScheduledFuture<?> schedule(final Callable<?> callable, long delay, TimeUnit unit) {
        final ScheduledFuture<?> delegate = this.poolSupplier.get().schedule(callable, delay, unit);
        return new ScheduledFuture<Object>(){

            public int hashCode() {
                return delegate.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Delayed)) {
                    return false;
                }
                return this.compareTo((Delayed)o) == 0;
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return delegate.getDelay(unit);
            }

            @Override
            public int compareTo(Delayed o) {
                return delegate.compareTo(o);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                FaultToleranceCommand command;
                BulkheadHelper bulkheadHelper;
                CommandRetrier.CommandCallable unwrapped = CommandScheduler.unwrapCallable(callable);
                if (unwrapped != null && (bulkheadHelper = (command = unwrapped.getCommand()).getBulkheadHelper()) != null && !bulkheadHelper.isInvocationRunning(command)) {
                    return delegate.cancel(true);
                }
                return delegate.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return delegate.isCancelled();
            }

            @Override
            public boolean isDone() {
                return delegate.isDone();
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                return delegate.get();
            }

            @Override
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return delegate.get(timeout, unit);
            }
        };
    }

    private static CommandRetrier.CommandCallable<?> unwrapCallable(Callable<?> callable) {
        Field[] fields = callable.getClass().getDeclaredFields();
        if (fields.length > 0) {
            try {
                fields[0].setAccessible(true);
                Callable unwrapped = (Callable)fields[0].get(callable);
                if (unwrapped instanceof CommandRetrier.CommandCallable) {
                    return (CommandRetrier.CommandCallable)unwrapped;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }
}

