/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.AsynchronousAntn;
import io.helidon.microprofile.faulttolerance.BulkheadAntn;
import io.helidon.microprofile.faulttolerance.CircuitBreakerAntn;
import io.helidon.microprofile.faulttolerance.CommandInterceptor;
import io.helidon.microprofile.faulttolerance.FallbackAntn;
import io.helidon.microprofile.faulttolerance.FaultToleranceMetrics;
import io.helidon.microprofile.faulttolerance.LiteralCommandBinding;
import io.helidon.microprofile.faulttolerance.MethodAntn;
import io.helidon.microprofile.faulttolerance.RetryAntn;
import io.helidon.microprofile.faulttolerance.TimeoutAntn;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceExtension
implements Extension {
    static final String MP_FT_NON_FALLBACK_ENABLED = "MP_Fault_Tolerance_NonFallback_Enabled";
    static final String MP_FT_METRICS_ENABLED = "MP_Fault_Tolerance_Metrics_Enabled";
    static final String MP_FT_INTERCEPTOR_PRIORITY = "mp.fault.tolerance.interceptor.priority";
    private static boolean isFaultToleranceEnabled = true;
    private static boolean isFaultToleranceMetricsEnabled = true;
    private Set<BeanMethod> registeredMethods;

    static boolean isFaultToleranceEnabled() {
        return isFaultToleranceEnabled;
    }

    static boolean isFaultToleranceMetricsEnabled() {
        return isFaultToleranceMetricsEnabled;
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery discovery, BeanManager bm) {
        Config config = ConfigProvider.getConfig();
        isFaultToleranceEnabled = config.getOptionalValue(MP_FT_NON_FALLBACK_ENABLED, Boolean.class).orElse(true);
        isFaultToleranceMetricsEnabled = config.getOptionalValue(MP_FT_METRICS_ENABLED, Boolean.class).orElse(true);
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Retry.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(CircuitBreaker.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Timeout.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Asynchronous.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Bulkhead.class), LiteralCommandBinding.getInstance()));
        discovery.addInterceptorBinding(new AnnotatedTypeWrapper(bm.createAnnotatedType(Fallback.class), LiteralCommandBinding.getInstance()));
        discovery.addAnnotatedType(bm.createAnnotatedType(CommandInterceptor.class), CommandInterceptor.class.getName());
    }

    void updatePriorityMaybe(@Observes ProcessAnnotatedType<CommandInterceptor> event) {
        Config config = ConfigProvider.getConfig();
        Optional priority = config.getOptionalValue(MP_FT_INTERCEPTOR_PRIORITY, Integer.class);
        priority.ifPresent(v -> event.configureAnnotatedType().remove(a -> a instanceof Priority).add((Annotation)((Object)new LiteralPriority((int)v))));
    }

    void registerFaultToleranceMethods(@Observes ProcessManagedBean<?> event) {
        AnnotatedType type = event.getAnnotatedBeanClass();
        for (AnnotatedMethod method : type.getMethods()) {
            if (!FaultToleranceExtension.isFaultToleranceMethod(type.getJavaClass(), method.getJavaMember())) continue;
            this.getRegisteredMethods().add(new BeanMethod(type.getJavaClass(), method.getJavaMember()));
        }
    }

    void registerFaultToleranceMetrics(@Observes AfterDeploymentValidation validation) {
        if (FaultToleranceMetrics.enabled()) {
            this.getRegisteredMethods().stream().forEach(beanMethod -> {
                Method method = beanMethod.method();
                Class<?> beanClass = beanMethod.beanClass();
                FaultToleranceMetrics.registerMetrics(method);
                if (MethodAntn.isAnnotationPresent(beanClass, method, Retry.class)) {
                    FaultToleranceMetrics.registerRetryMetrics(method);
                    new RetryAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, CircuitBreaker.class)) {
                    FaultToleranceMetrics.registerCircuitBreakerMetrics(method);
                    new CircuitBreakerAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, Timeout.class)) {
                    FaultToleranceMetrics.registerTimeoutMetrics(method);
                    new TimeoutAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, Bulkhead.class)) {
                    FaultToleranceMetrics.registerBulkheadMetrics(method);
                    new BulkheadAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, Fallback.class)) {
                    FaultToleranceMetrics.registerFallbackMetrics(method);
                    new FallbackAntn(beanClass, method).validate();
                }
                if (MethodAntn.isAnnotationPresent(beanClass, method, Asynchronous.class)) {
                    new AsynchronousAntn(beanClass, method).validate();
                }
            });
        }
    }

    private Set<BeanMethod> getRegisteredMethods() {
        if (this.registeredMethods == null) {
            this.registeredMethods = new CopyOnWriteArraySet<BeanMethod>();
        }
        return this.registeredMethods;
    }

    static Class<?> getRealClass(Object object) {
        Class<?> result = object.getClass();
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }

    static boolean isFaultToleranceMethod(Class<?> beanClass, Method method) {
        return MethodAntn.isAnnotationPresent(beanClass, method, Retry.class) || MethodAntn.isAnnotationPresent(beanClass, method, CircuitBreaker.class) || MethodAntn.isAnnotationPresent(beanClass, method, Bulkhead.class) || MethodAntn.isAnnotationPresent(beanClass, method, Timeout.class) || MethodAntn.isAnnotationPresent(beanClass, method, Asynchronous.class) || MethodAntn.isAnnotationPresent(beanClass, method, Fallback.class);
    }

    public static class AnnotatedTypeWrapper<T>
    implements AnnotatedType<T> {
        private final AnnotatedType<T> delegate;
        private final Set<Annotation> annotationSet;

        public AnnotatedTypeWrapper(AnnotatedType<T> delegate, Annotation ... annotations) {
            this.delegate = delegate;
            this.annotationSet = new HashSet<Annotation>(Arrays.asList(annotations));
            for (Annotation da : delegate.getAnnotations()) {
                boolean overridden = false;
                for (Annotation na : this.annotationSet) {
                    if (!da.annotationType().isAssignableFrom(na.annotationType())) continue;
                    overridden = true;
                    break;
                }
                if (overridden) continue;
                this.annotationSet.add(da);
            }
        }

        public Class<T> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public Set<AnnotatedConstructor<T>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super T>> getMethods() {
            return this.delegate.getMethods();
        }

        public Set<AnnotatedField<? super T>> getFields() {
            return this.delegate.getFields();
        }

        public <R extends Annotation> R getAnnotation(Class<R> annotationType) {
            Optional<Annotation> optional = this.annotationSet.stream().filter(a -> annotationType.isAssignableFrom(a.annotationType())).findFirst();
            return (R)(optional.isPresent() ? optional.get() : null);
        }

        public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
            return this.annotationSet.stream().filter(a -> annotationType.isAssignableFrom(a.annotationType())).collect(Collectors.toSet());
        }

        public Set<Annotation> getAnnotations() {
            return this.annotationSet;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            Annotation annotation = this.getAnnotation(annotationType);
            return annotation != null;
        }
    }

    private static class LiteralPriority
    extends AnnotationLiteral<Priority>
    implements Priority {
        private final int value;

        LiteralPriority(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    private static class BeanMethod {
        private final Class<?> beanClass;
        private final Method method;

        BeanMethod(Class<?> beanClass, Method method) {
            this.beanClass = beanClass;
            this.method = method;
        }

        Class<?> beanClass() {
            return this.beanClass;
        }

        Method method() {
            return this.method;
        }
    }
}

