/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.JavaMethodFinder;
import io.helidon.microprofile.faulttolerance.MethodAntn;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FallbackAntn
extends MethodAntn
implements Fallback {
    public FallbackAntn(Class<?> beanClass, Method method) {
        super(beanClass, method);
    }

    @Override
    public void validate() {
        String methodName = this.fallbackMethod();
        Class<FallbackHandler<?>> value = this.value();
        if (value != Fallback.DEFAULT.class && !methodName.isEmpty()) {
            throw new FaultToleranceDefinitionException("Fallback annotation cannot declare a handler and a fallback method");
        }
        Method method = this.method();
        if (!methodName.isEmpty()) {
            try {
                Method fallbackMethod = JavaMethodFinder.findMethod(method.getDeclaringClass(), methodName, method.getGenericParameterTypes());
                if (!(fallbackMethod.getReturnType().isAssignableFrom(method.getReturnType()) || Future.class.isAssignableFrom(method.getReturnType()) || CompletionStage.class.isAssignableFrom(method.getReturnType()))) {
                    throw new FaultToleranceDefinitionException("Fallback method return type is invalid: " + fallbackMethod.getReturnType());
                }
            }
            catch (NoSuchMethodException e) {
                throw new FaultToleranceDefinitionException((Throwable)e);
            }
        }
        if (value != Fallback.DEFAULT.class) {
            try {
                Method handleMethod = value.getMethod("handle", ExecutionContext.class);
                if (!handleMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    throw new FaultToleranceDefinitionException("Handler method return type is invalid: " + handleMethod.getReturnType());
                }
            }
            catch (NoSuchMethodException e) {
                throw new FaultToleranceDefinitionException((Throwable)e);
            }
        }
    }

    public Class<? extends FallbackHandler<?>> value() {
        MethodAntn.LookupResult<Fallback> lookupResult = this.lookupAnnotation(Fallback.class);
        String override = this.getParamOverride("value", lookupResult.getType());
        try {
            return override != null ? Class.forName(override) : lookupResult.getAnnotation().value();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String fallbackMethod() {
        MethodAntn.LookupResult<Fallback> lookupResult = this.lookupAnnotation(Fallback.class);
        String override = this.getParamOverride("fallbackMethod", lookupResult.getType());
        return override != null ? override : lookupResult.getAnnotation().fallbackMethod();
    }
}

