/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.internal.util.Assert;

class FailsafeChainedFuture<T>
implements Future<T> {
    private final FailsafeFuture<T> delegate;

    FailsafeChainedFuture(FailsafeFuture<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public T get() throws CancellationException, InterruptedException, ExecutionException {
        try {
            return this.getResult(-1L, null);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws CancellationException, InterruptedException, ExecutionException, TimeoutException {
        Assert.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout must not be negative", (Object[])new Object[0]);
        return this.getResult(timeout, unit);
    }

    private T getResult(long timeout, TimeUnit unit) throws CancellationException, InterruptedException, ExecutionException, TimeoutException {
        try {
            Object result;
            Object object = result = timeout < 0L ? this.delegate.get() : this.delegate.get(timeout, unit);
            if (result instanceof Future) {
                Future future = (Future)result;
                return (T)(timeout < 0L ? future.get() : future.get(timeout, unit));
            }
            return (T)result;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw e;
        }
    }
}

